/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation.ExceptionThrowingConsumer;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.PooledByteBufAllocator;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscriber;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.nio.ByteBuffer;

public class ByteBufWriteSubscriber
implements Subscriber<ByteBuf> {
    private final ExceptionThrowingConsumer<ByteBuffer> writer;
    private final MonoSink<Void> emitter;
    private final int bufferSize;
    private final ByteBuf buffer;
    private Subscription subscription;
    private boolean done = false;

    public ByteBufWriteSubscriber(ExceptionThrowingConsumer<ByteBuffer> writer, MonoSink<Void> emitter, Long bodySize) {
        this.writer = writer;
        this.emitter = emitter;
        this.bufferSize = bodySize == null ? 65536 : (int)Math.max(8192L, Math.min(bodySize, 65536L));
        this.buffer = PooledByteBufAllocator.DEFAULT.buffer(this.bufferSize);
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (Operators.validate(this.subscription, s2)) {
            this.subscription = s2;
            s2.request(1L);
        }
    }

    @Override
    public void onNext(ByteBuf bytes) {
        if (this.done) {
            Operators.onNextDropped(bytes, Context.of(this.emitter.contextView()));
            return;
        }
        if (!bytes.isReadable()) {
            this.subscription.request(1L);
            return;
        }
        if (bytes.readableBytes() > this.bufferSize) {
            if (this.buffer.readableBytes() > 0) {
                this.write(this.buffer);
                this.buffer.clear();
            }
            this.write(bytes);
        } else if (this.buffer.writableBytes() >= bytes.readableBytes()) {
            this.buffer.writeBytes(bytes);
        } else {
            this.write(this.buffer);
            this.buffer.clear();
            this.buffer.writeBytes(bytes);
        }
        if (!this.done) {
            this.subscription.request(1L);
        }
    }

    private void write(ByteBuf byteBuf) {
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        try {
            while (byteBuffer.hasRemaining()) {
                this.writer.consume(byteBuffer);
            }
        }
        catch (Exception ex) {
            this.onError(ex);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.done) {
            Operators.onErrorDropped(throwable, Context.of(this.emitter.contextView()));
            return;
        }
        this.done = true;
        this.buffer.release();
        this.subscription.cancel();
        this.emitter.error(throwable);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        if (this.buffer.readableBytes() > 0) {
            this.write(this.buffer);
            if (this.done) {
                return;
            }
        }
        this.done = true;
        this.buffer.release();
        this.emitter.success();
    }
}

