/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.okhttp3.MediaType;
import com.dataiku.dss.shadelibazure.okhttp3.RequestBody;
import com.dataiku.dss.shadelibazure.okio.BufferedSink;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class BinaryDataRequestBody
extends RequestBody {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDataRequestBody.class);
    private final MediaType contentType;
    private final BinaryData body;
    private final long effectiveContentLength;
    private volatile int bodySent = 0;
    private static final AtomicIntegerFieldUpdater<BinaryDataRequestBody> BODY_SENT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(BinaryDataRequestBody.class, "bodySent");

    public BinaryDataRequestBody(BinaryData body, MediaType contentType, long effectiveContentLength) {
        this.body = body;
        this.contentType = contentType;
        this.effectiveContentLength = effectiveContentLength;
    }

    @Override
    public long contentLength() throws IOException {
        return this.effectiveContentLength;
    }

    @Override
    public boolean isOneShot() {
        return !this.body.isReplayable();
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (!this.body.isReplayable() && !BODY_SENT_UPDATER.compareAndSet(this, 0, 1)) {
            throw LOGGER.logThrowableAsError(new IOException("Re-attempt to send body is not supported."));
        }
        this.body.writeTo(bufferedSink);
    }
}

