/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.io.IOUtils;
import com.dataiku.dss.shadelibazure.okhttp3.Response;
import com.dataiku.dss.shadelibazure.okhttp3.ResponseBody;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;

public final class OkHttpAsyncResponse
extends OkHttpAsyncResponseBase {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 8192;
    private final ResponseBody responseBody;

    public OkHttpAsyncResponse(Response response, HttpRequest request, boolean eagerlyConvertHeaders) {
        super(response, request, eagerlyConvertHeaders);
        this.responseBody = response.body();
    }

    @Override
    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromStream(this.responseBody.byteStream());
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        if (this.responseBody == null) {
            return Flux.empty();
        }
        return Flux.using(this.responseBody::byteStream, bodyStream -> FluxUtil.toFluxByteBuffer(bodyStream, 8192), bodyStream -> this.close(), false);
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.responseBody == null) {
                return null;
            }
            byte[] content = this.responseBody.bytes();
            if (content.length == 0) {
                return null;
            }
            return content;
        });
    }

    @Override
    public Mono<InputStream> getBodyAsInputStream() {
        if (this.responseBody == null) {
            return Mono.empty();
        }
        return Mono.fromSupplier(this.responseBody::byteStream);
    }

    @Override
    public void writeBodyTo(WritableByteChannel channel) throws IOException {
        if (this.responseBody != null) {
            try {
                IOUtils.transfer(this.responseBody.source(), channel, this.responseBody.contentLength());
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        if (this.responseBody != null) {
            return Mono.using(() -> this, ignored -> IOUtils.transferAsync(this.responseBody.source(), channel, this.responseBody.contentLength()), OkHttpAsyncResponse::close);
        }
        return Mono.empty();
    }

    @Override
    public void close() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }
}

