/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpToAzureCoreHttpHeadersWrapper;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.okhttp3.Headers;
import com.dataiku.dss.shadelibazure.okhttp3.Response;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.nio.charset.Charset;

abstract class OkHttpAsyncResponseBase
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    OkHttpAsyncResponseBase(Response response, HttpRequest request, boolean eagerlyConvertHeaders) {
        super(request);
        this.statusCode = response.code();
        this.headers = eagerlyConvertHeaders ? OkHttpAsyncResponseBase.fromOkHttpHeaders(response.headers()) : new OkHttpToAzureCoreHttpHeadersWrapper(response.headers());
    }

    @Override
    public final int getStatusCode() {
        return this.statusCode;
    }

    @Override
    @Deprecated
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public final String getHeaderValue(HttpHeaderName headerName) {
        return this.headers.getValue(headerName);
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString(bytes, this.getHeaderValue("Content-Type")));
    }

    @Override
    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    static HttpHeaders fromOkHttpHeaders(Headers okHttpHeaders) {
        HttpHeaders azureHeaders = new HttpHeaders((int)((float)okHttpHeaders.size() / 0.75f));
        okHttpHeaders.forEach(nameValuePair -> azureHeaders.add((String)nameValuePair.getFirst(), (String)nameValuePair.getSecond()));
        return azureHeaders;
    }
}

