/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.util.AuthorizationChallengeHandler;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.okhttp3.Authenticator;
import com.dataiku.dss.shadelibazure.okhttp3.Challenge;
import com.dataiku.dss.shadelibazure.okhttp3.Interceptor;
import com.dataiku.dss.shadelibazure.okhttp3.Request;
import com.dataiku.dss.shadelibazure.okhttp3.Response;
import com.dataiku.dss.shadelibazure.okhttp3.Route;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;

public final class ProxyAuthenticator
implements Authenticator {
    private static final String VALIDATION_ERROR_TEMPLATE = "The '%s' returned in the 'Proxy-Authentication-Info' header doesn't match the value sent in the 'Proxy-Authorization' header. Sent: %s, received: %s.";
    private static final String BASIC = "basic";
    private static final String DIGEST = "digest";
    private static final String PREEMPTIVE_AUTHENTICATE = "Preemptive Authenticate";
    private static final String PROXY_METHOD = HttpMethod.CONNECT.name();
    private static final String PROXY_URI_PATH = "/";
    private static final Supplier<byte[]> NO_BODY = () -> new byte[0];
    private static final String CNONCE = "cnonce";
    private static final String NC = "nc";
    private static final ClientLogger LOGGER = new ClientLogger(ProxyAuthenticator.class);
    private final AuthorizationChallengeHandler challengeHandler;

    public ProxyAuthenticator(String username, String password) {
        this.challengeHandler = new AuthorizationChallengeHandler(username, password);
    }

    public Interceptor getProxyAuthenticationInfoInterceptor() {
        return new ProxyAuthenticationInfoInterceptor(this.challengeHandler);
    }

    @Override
    public Request authenticate(Route route, Response response) {
        String authorizationHeader = this.challengeHandler.attemptToPipelineAuthorization(PROXY_METHOD, PROXY_URI_PATH, NO_BODY);
        if (!CoreUtils.isNullOrEmpty(authorizationHeader)) {
            return response.request().newBuilder().header("Proxy-Authorization", authorizationHeader).build();
        }
        if (PREEMPTIVE_AUTHENTICATE.equalsIgnoreCase(response.message())) {
            return response.request();
        }
        boolean hasBasicChallenge = false;
        ArrayList<Map<String, String>> digestChallenges = new ArrayList<Map<String, String>>();
        for (Challenge challenge : response.challenges()) {
            if (BASIC.equalsIgnoreCase(challenge.scheme())) {
                hasBasicChallenge = true;
                continue;
            }
            if (!DIGEST.equalsIgnoreCase(challenge.scheme())) continue;
            digestChallenges.add(challenge.authParams());
        }
        if (digestChallenges.size() > 0) {
            authorizationHeader = this.challengeHandler.handleDigest(PROXY_METHOD, PROXY_URI_PATH, digestChallenges, NO_BODY);
        }
        if (authorizationHeader == null && hasBasicChallenge) {
            authorizationHeader = this.challengeHandler.handleBasic();
        }
        Request.Builder requestBuilder = response.request().newBuilder();
        if (authorizationHeader != null) {
            requestBuilder.header("Proxy-Authorization", authorizationHeader);
        }
        return requestBuilder.build();
    }

    private static void validateProxyAuthenticationInfoValue(String name, Map<String, String> authenticationInfoPieces, Map<String, String> authorizationPieces) {
        if (authenticationInfoPieces.containsKey(name)) {
            String sentValue = authorizationPieces.get(name);
            String receivedValue = authenticationInfoPieces.get(name);
            if (!receivedValue.equalsIgnoreCase(sentValue)) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(String.format(VALIDATION_ERROR_TEMPLATE, name, sentValue, receivedValue)));
            }
        }
    }

    private static class ProxyAuthenticationInfoInterceptor
    implements Interceptor {
        private final AuthorizationChallengeHandler challengeHandler;

        ProxyAuthenticationInfoInterceptor(AuthorizationChallengeHandler challengeHandler) {
            this.challengeHandler = challengeHandler;
        }

        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response response = chain.proceed(chain.request());
            String proxyAuthenticationInfoHeader = response.header("Proxy-Authentication-Info");
            if (!CoreUtils.isNullOrEmpty(proxyAuthenticationInfoHeader)) {
                Map<String, String> authenticationInfoPieces = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader(proxyAuthenticationInfoHeader);
                Map<String, String> authorizationPieces = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader(chain.request().header("Proxy-Authorization"));
                ProxyAuthenticator.validateProxyAuthenticationInfoValue(ProxyAuthenticator.CNONCE, authenticationInfoPieces, authorizationPieces);
                ProxyAuthenticator.validateProxyAuthenticationInfoValue(ProxyAuthenticator.NC, authenticationInfoPieces, authorizationPieces);
                this.challengeHandler.consumeAuthenticationInfoHeader(authenticationInfoPieces);
            }
            return response;
        }
    }
}

