/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CookiePolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(CookiePolicy.class);
    private final CookieHandler cookies = new CookieManager();

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return Mono.defer(() -> {
            CookiePolicy.beforeRequest(context.getHttpRequest(), this.cookies);
            return next.process();
        }).map(response -> CookiePolicy.afterResponse(context, response, this.cookies));
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        CookiePolicy.beforeRequest(context.getHttpRequest(), this.cookies);
        return CookiePolicy.afterResponse(context, next.processSync(), this.cookies);
    }

    private static void beforeRequest(HttpRequest httpRequest, CookieHandler cookies) {
        try {
            URI uri = httpRequest.getUrl().toURI();
            HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
            for (HttpHeader header : httpRequest.getHeaders()) {
                cookieHeaders.put(header.getName(), header.getValuesList());
            }
            Map<String, List<String>> requestCookies = cookies.get(uri, cookieHeaders);
            for (Map.Entry<String, List<String>> entry : requestCookies.entrySet()) {
                httpRequest.getHeaders().set(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException | URISyntaxException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private static HttpResponse afterResponse(HttpPipelineCallContext context, HttpResponse response, CookieHandler cookies) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (HttpHeader header : response.getHeaders()) {
            responseHeaders.put(header.getName(), header.getValuesList());
        }
        try {
            URI uri = context.getHttpRequest().getUrl().toURI();
            cookies.put(uri, responseHeaders);
        }
        catch (IOException | URISyntaxException e) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate(e));
        }
        return response;
    }
}

