/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.rest;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public final class StreamResponse
extends SimpleResponse<Flux<ByteBuffer>>
implements Closeable {
    private static final ClientLogger LOGGER = new ClientLogger(StreamResponse.class);
    private volatile boolean consumed;
    private final HttpResponse response;

    @Deprecated
    public StreamResponse(HttpRequest request, int statusCode, HttpHeaders headers, Flux<ByteBuffer> value) {
        super(request, statusCode, headers, value);
        this.response = null;
    }

    public StreamResponse(HttpResponse response) {
        super(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        this.response = response;
    }

    @Override
    public Flux<ByteBuffer> getValue() {
        if (this.response == null) {
            return Flux.using(() -> this, ignored -> (Publisher)super.getValue(), response -> {
                response.consumed = true;
            });
        }
        return Flux.using(() -> this.response, HttpResponse::getBody, r -> {
            this.consumed = true;
            r.close();
        });
    }

    public Mono<Void> writeValueToAsync(AsynchronousByteChannel channel) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        if (this.response == null) {
            return FluxUtil.writeToAsynchronousByteChannel((Flux<ByteBuffer>)this.getValue(), channel);
        }
        return this.response.writeBodyToAsync(channel);
    }

    public void writeValueTo(WritableByteChannel channel) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        if (this.response == null) {
            FluxUtil.writeToWritableByteChannel((Flux<ByteBuffer>)this.getValue(), channel).block();
        } else {
            try {
                this.response.writeBodyTo(channel);
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
            }
        }
    }

    @Override
    public void close() {
        if (this.consumed) {
            return;
        }
        this.consumed = true;
        if (this.response == null) {
            Object value = this.getValue();
            ((Flux)value).subscribe().dispose();
        } else {
            this.response.close();
        }
    }
}

