/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.UrlSanitizer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.SpanKind;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.StartSpanOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.Tracer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class InstrumentationPolicy
implements HttpPipelinePolicy {
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    private static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";
    private static final String HTTP_RESEND_COUNT = "http.request.resend_count";
    private static final String SERVER_ADDRESS = "server.address";
    private static final String SERVER_PORT = "server.port";
    private static final ClientLogger LOGGER = new ClientLogger(InstrumentationPolicy.class);
    private static final String OTHER_ERROR_TYPE = "_OTHER";
    private UrlSanitizer urlSanitizer;
    private Tracer tracer;

    public void initialize(Tracer tracer, UrlSanitizer urlSanitizer) {
        this.tracer = tracer;
        this.urlSanitizer = urlSanitizer;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!this.isTracingEnabled(context)) {
            return next.process();
        }
        return Mono.using(() -> this.startSpan(context), span -> next.process().map(response -> {
            this.onResponseCode((HttpResponse)response, (Context)span);
            return TraceableResponse.create(response, this.tracer, span);
        }).doOnCancel(() -> this.tracer.end("cancelled", null, (Context)span)).doOnError(exception -> this.tracer.end(null, (Throwable)exception, (Context)span)), __ -> {});
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        HttpResponse httpResponse;
        block10: {
            if (!this.isTracingEnabled(context)) {
                return next.processSync();
            }
            Context span = this.startSpan(context);
            AutoCloseable scope = this.tracer.makeSpanCurrent(span);
            try {
                HttpResponse response = next.processSync();
                this.onResponseCode(response, span);
                httpResponse = TraceableResponse.create(response, this.tracer, span);
                if (scope == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    this.tracer.end(null, (Throwable)ex, span);
                    throw ex;
                }
                catch (Exception ex) {
                    this.tracer.end(null, (Throwable)ex, span);
                    throw LOGGER.logExceptionAsWarning(new RuntimeException(ex));
                }
            }
            scope.close();
        }
        return httpResponse;
    }

    private Context startSpan(HttpPipelineCallContext azContext) {
        HttpRequest request = azContext.getHttpRequest();
        String methodName = request.getHttpMethod().toString();
        StartSpanOptions spanOptions = new StartSpanOptions(SpanKind.CLIENT).setAttribute(HTTP_METHOD, methodName).setAttribute(HTTP_URL, this.urlSanitizer.getRedactedUrl(request.getUrl())).setAttribute(SERVER_ADDRESS, request.getUrl().getHost()).setAttribute(SERVER_PORT, InstrumentationPolicy.getPort(request.getUrl()));
        Context span = this.tracer.start(methodName, spanOptions, azContext.getContext());
        this.addPostSamplingAttributes(span, request);
        this.tracer.injectContext((k, v) -> request.getHeaders().set((String)k, (String)v), span);
        return span;
    }

    private static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    private void addPostSamplingAttributes(Context span, HttpRequest request) {
        String requestId;
        Object rawRetryCount = span.getData("requestRetryCount").orElse(null);
        if (rawRetryCount instanceof Integer && (Integer)rawRetryCount > 0) {
            this.tracer.setAttribute(HTTP_RESEND_COUNT, ((Integer)rawRetryCount).longValue(), span);
        }
        if (!CoreUtils.isNullOrEmpty(requestId = request.getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID))) {
            this.tracer.setAttribute(CLIENT_REQUEST_ID_ATTRIBUTE, requestId, span);
        }
    }

    private void onResponseCode(HttpResponse response, Context span) {
        if (response != null && this.tracer.isRecording(span)) {
            int statusCode = response.getStatusCode();
            this.tracer.setAttribute(HTTP_STATUS_CODE, statusCode, span);
            String requestId = response.getHeaderValue(HttpHeaderName.X_MS_REQUEST_ID);
            if (requestId != null) {
                this.tracer.setAttribute(SERVICE_REQUEST_ID_ATTRIBUTE, requestId, span);
            }
        }
    }

    private boolean isTracingEnabled(HttpPipelineCallContext context) {
        return this.tracer != null && this.tracer.isEnabled() && (Boolean)context.getData("disable-tracing").orElse(false) == false;
    }

    private static final class TraceableResponse
    extends HttpResponse {
        private final HttpResponse response;
        private final Context span;
        private final Tracer tracer;
        private volatile int ended = 0;
        private static final AtomicIntegerFieldUpdater<TraceableResponse> ENDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TraceableResponse.class, "ended");

        private TraceableResponse(HttpResponse response, Tracer tracer, Context span) {
            super(response.getRequest());
            this.response = response;
            this.span = span;
            this.tracer = tracer;
        }

        public static HttpResponse create(HttpResponse response, Tracer tracer, Context span) {
            if (tracer.isRecording(span)) {
                return new TraceableResponse(response, tracer, span);
            }
            tracer.end(null, null, span);
            return response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusCode();
        }

        @Override
        @Deprecated
        public String getHeaderValue(String name) {
            return this.response.getHeaderValue(name);
        }

        @Override
        public String getHeaderValue(HttpHeaderName headerName) {
            return this.response.getHeaderValue(headerName);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            return Flux.using(() -> this.span, s2 -> this.response.getBody().doOnError(e -> this.onError(null, (Throwable)e)).doOnCancel(() -> this.onError("cancelled", null)), s2 -> this.endNoError());
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return this.endSpanWhen(this.response.getBodyAsByteArray());
        }

        @Override
        public Mono<String> getBodyAsString() {
            return this.endSpanWhen(this.response.getBodyAsString());
        }

        @Override
        public BinaryData getBodyAsBinaryData() {
            try {
                BinaryData binaryData = this.response.getBodyAsBinaryData();
                return binaryData;
            }
            catch (Exception e) {
                this.onError(null, e);
                throw e;
            }
            finally {
                this.endNoError();
            }
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return this.endSpanWhen(this.response.getBodyAsString(charset));
        }

        @Override
        public Mono<InputStream> getBodyAsInputStream() {
            return this.endSpanWhen(this.response.getBodyAsInputStream());
        }

        @Override
        public void close() {
            this.response.close();
            this.endNoError();
        }

        private <T> Mono<T> endSpanWhen(Mono<T> publisher) {
            return Mono.using(() -> this.span, s2 -> publisher.doOnError(e -> this.onError(null, (Throwable)e)).doOnCancel(() -> this.onError("cancelled", null)), s2 -> this.endNoError());
        }

        private void onError(String errorType, Throwable error) {
            if (ENDED_UPDATER.compareAndSet(this, 0, 1)) {
                this.tracer.end(errorType, error, this.span);
            }
        }

        private void endNoError() {
            if (ENDED_UPDATER.compareAndSet(this, 0, 1)) {
                String errorType = null;
                if (this.response == null) {
                    errorType = InstrumentationPolicy.OTHER_ERROR_TYPE;
                } else if (this.response.getStatusCode() >= 400) {
                    errorType = String.valueOf(this.response.getStatusCode());
                }
                this.tracer.end(errorType, null, this.span);
            }
        }
    }
}

