/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.Substitution;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RangeReplaceSubstitution
extends Substitution
implements Comparable<RangeReplaceSubstitution> {
    private final int start;
    private final int end;

    private RangeReplaceSubstitution(String urlParameterName, int methodParameterIndex, boolean shouldEncode, int start, int end) {
        super(urlParameterName, methodParameterIndex, shouldEncode);
        this.start = start;
        this.end = end;
    }

    public static List<RangeReplaceSubstitution> getRangeReplaceSubstitutions(String urlParameterName, int methodParameterIndex, boolean shouldEncode, String substitutionBase) {
        ArrayList<RangeReplaceSubstitution> substitutions = new ArrayList<RangeReplaceSubstitution>();
        String placeholder = "{" + urlParameterName + "}";
        int indexOf = 0;
        while ((indexOf = substitutionBase.indexOf(placeholder, indexOf)) != -1) {
            substitutions.add(new RangeReplaceSubstitution(urlParameterName, methodParameterIndex, shouldEncode, indexOf, indexOf + placeholder.length()));
            indexOf += placeholder.length();
        }
        return substitutions;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getSize() {
        return this.end - this.start;
    }

    @Override
    public int compareTo(RangeReplaceSubstitution o) {
        if (this.start < o.start) {
            return -1;
        }
        if (this.start > o.start) {
            return 1;
        }
        return Integer.compare(this.end, o.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeReplaceSubstitution)) {
            return false;
        }
        RangeReplaceSubstitution other = (RangeReplaceSubstitution)obj;
        return this.start == other.start && this.end == other.end;
    }
}

