/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectionUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectiveInvoker;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson.JacksonDatabind212;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson.JacksonVersion;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson.ObjectMapperFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.cfg.PackageVersion;

public final class XmlMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(XmlMapperFactory.class);
    private static final String XML_MAPPER = "com.dataiku.dss.shadelibazure.com.fasterxml.jackson.dataformat.xml.XmlMapper";
    private static final String XML_MAPPER_BUILDER = "com.dataiku.dss.shadelibazure.com.fasterxml.jackson.dataformat.xml.XmlMapper$Builder";
    private static final String FROM_XML_PARSER = "com.dataiku.dss.shadelibazure.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser$Feature";
    private static final String TO_XML_GENERATOR = "com.dataiku.dss.shadelibazure.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator$Feature";
    private final ReflectiveInvoker createXmlMapperBuilder;
    private final ReflectiveInvoker defaultUseWrapper;
    private final ReflectiveInvoker configureWriteXmlDeclaration;
    private final Object writeXmlDeclaration;
    private final ReflectiveInvoker configureEmptyElementAsNull;
    private final Object emptyElementAsNull;
    final boolean useJackson212;
    private boolean jackson212IsSafe = true;
    public static final XmlMapperFactory INSTANCE = new XmlMapperFactory();

    private XmlMapperFactory() {
        Object emptyElementAsNull;
        ReflectiveInvoker configureEmptyElementAsNull;
        Object writeXmlDeclaration;
        ReflectiveInvoker configureWriteXmlDeclaration;
        ReflectiveInvoker defaultUseWrapper;
        ReflectiveInvoker createXmlMapperBuilder;
        ClassLoader thisClassLoader = XmlMapperFactory.class.getClassLoader();
        try {
            Class<?> xmlMapper = Class.forName(XML_MAPPER, true, thisClassLoader);
            Class<?> xmlMapperBuilder = Class.forName(XML_MAPPER_BUILDER, true, thisClassLoader);
            Class<?> fromXmlParser = Class.forName(FROM_XML_PARSER, true, thisClassLoader);
            Class<?> toXmlGenerator = Class.forName(TO_XML_GENERATOR, true, thisClassLoader);
            createXmlMapperBuilder = ReflectionUtils.getMethodInvoker(xmlMapper, xmlMapper.getDeclaredMethod("builder", new Class[0]), false);
            defaultUseWrapper = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, xmlMapperBuilder.getDeclaredMethod("defaultUseWrapper", Boolean.TYPE), false);
            configureWriteXmlDeclaration = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, xmlMapperBuilder.getDeclaredMethod("configure", toXmlGenerator, Boolean.TYPE), false);
            writeXmlDeclaration = toXmlGenerator.getDeclaredField("WRITE_XML_DECLARATION").get(null);
            configureEmptyElementAsNull = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, xmlMapperBuilder.getDeclaredMethod("configure", fromXmlParser, Boolean.TYPE), false);
            emptyElementAsNull = fromXmlParser.getDeclaredField("EMPTY_ELEMENT_AS_NULL").get(null);
        }
        catch (Throwable ex) {
            if (ex instanceof Error && !(ex instanceof LinkageError)) {
                throw LOGGER.logThrowableAsError((Error)ex);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Failed to retrieve invoker used to create XmlMapper. XML serialization won't be supported until 'com.fasterxml.jackson.dataformat:jackson-dataformat-xml' is added to the classpath or updated to a supported version. " + JacksonVersion.getHelpInfo(), ex));
        }
        this.createXmlMapperBuilder = createXmlMapperBuilder;
        this.defaultUseWrapper = defaultUseWrapper;
        this.configureWriteXmlDeclaration = configureWriteXmlDeclaration;
        this.writeXmlDeclaration = writeXmlDeclaration;
        this.configureEmptyElementAsNull = configureEmptyElementAsNull;
        this.emptyElementAsNull = emptyElementAsNull;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    public ObjectMapper createXmlMapper() {
        Object xmlMapper;
        try {
            MapperBuilder xmlMapperBuilder = ObjectMapperFactory.initializeMapperBuilder((MapperBuilder)this.createXmlMapperBuilder.invokeStatic(new Object[0]));
            this.defaultUseWrapper.invokeWithArguments(xmlMapperBuilder, false);
            this.configureWriteXmlDeclaration.invokeWithArguments(xmlMapperBuilder, this.writeXmlDeclaration, true);
            this.configureEmptyElementAsNull.invokeWithArguments(xmlMapperBuilder, this.emptyElementAsNull, true);
            xmlMapper = xmlMapperBuilder.build();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Unable to create XmlMapper instance.", exception));
        }
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                return JacksonDatabind212.mutateXmlCoercions(xmlMapper);
            }
            catch (Throwable ex) {
                if (ex instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, ex);
                }
                throw ex;
            }
        }
        return xmlMapper;
    }
}

