/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.util;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataContent;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataContentType;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.IterableOfByteBuffersInputStream;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.StreamUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.io.IOUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.ObjectSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.TypeReference;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Schedulers;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public final class InputStreamContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(InputStreamContent.class);
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 8192;
    private static final int MAX_BUFFER_CHUNK_SIZE = 0x800000;
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private final Supplier<InputStream> content;
    private final Long length;
    private final boolean isReplayable;
    private final List<ByteBuffer> bufferedContent;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<InputStreamContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InputStreamContent.class, byte[].class, "bytes");

    public InputStreamContent(InputStream inputStream2, Long length) {
        Objects.requireNonNull(inputStream2, "'inputStream' cannot be null.");
        this.length = length;
        this.isReplayable = InputStreamContent.canMarkReset(inputStream2, length);
        if (this.isReplayable) {
            inputStream2.mark(length.intValue());
            this.content = () -> InputStreamContent.resettableContent(inputStream2);
        } else {
            this.content = () -> inputStream2;
        }
        this.bufferedContent = null;
    }

    private InputStreamContent(Supplier<InputStream> inputStreamSupplier, Long length, List<ByteBuffer> bufferedContent) {
        this.content = Objects.requireNonNull(inputStreamSupplier, "'inputStreamSupplier' cannot be null.");
        this.length = length;
        this.isReplayable = true;
        this.bufferedContent = bufferedContent;
    }

    @Override
    public Long getLength() {
        byte[] data = BYTES_UPDATER.get(this);
        if (data != null) {
            return data.length;
        }
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return this.content.get();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        if (this.bufferedContent != null) {
            return Flux.fromIterable(this.bufferedContent).map(ByteBuffer::asReadOnlyBuffer);
        }
        return FluxUtil.toFluxByteBuffer(this.content.get(), 8192);
    }

    @Override
    public void writeTo(OutputStream outputStream2) throws IOException {
        this.writeTo(Channels.newChannel(outputStream2));
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        InputStream inputStream2 = this.content.get();
        if (this.bufferedContent != null) {
            for (ByteBuffer bb : this.bufferedContent) {
                ImplUtils.fullyWriteBuffer(bb.duplicate(), channel);
            }
        } else {
            IOUtils.transfer(Channels.newChannel(inputStream2), channel, this.length);
        }
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel channel) {
        if (channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.toFluxByteBuffer(), channel);
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) throws IOException {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        jsonWriter.writeBinary(this.toBytes());
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        if (this.isReplayable) {
            return this;
        }
        return InputStreamContent.readAndBuffer(this.content.get(), this.length);
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        if (this.isReplayable) {
            return Mono.just(this);
        }
        InputStream inputStream2 = this.content.get();
        return Mono.just(inputStream2).publishOn(Schedulers.boundedElastic()).map(is -> InputStreamContent.readAndBuffer(is, this.length));
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private static boolean canMarkReset(InputStream inputStream2, Long length) {
        return length != null && length < 0x7FFFFFF7L && inputStream2.markSupported();
    }

    private static InputStream resettableContent(InputStream stream) {
        try {
            stream.reset();
            return stream;
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
        }
    }

    private static InputStreamContent readAndBuffer(InputStream inputStream2, Long length) {
        try {
            Tuple2<Long, List<ByteBuffer>> streamRead = StreamUtil.readStreamToListOfByteBuffers(inputStream2, length, 8192, 0x800000);
            long readLength = streamRead.getT1();
            List<ByteBuffer> byteBuffers = streamRead.getT2();
            if (length == null || length != readLength) {
                return new InputStreamContent(() -> new IterableOfByteBuffersInputStream(byteBuffers), readLength, byteBuffers);
            }
            return new InputStreamContent(() -> new IterableOfByteBuffersInputStream(byteBuffers), length, byteBuffers);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
        }
    }

    private byte[] getBytes() {
        try {
            int nRead;
            AccessibleByteArrayOutputStream dataOutputBuffer = this.length == null || this.length < 0x7FFFFFF7L ? new AccessibleByteArrayOutputStream() : new AccessibleByteArrayOutputStream(this.length.intValue());
            byte[] data = new byte[8192];
            InputStream inputStream2 = this.content.get();
            while ((nRead = inputStream2.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArray();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }
}

