/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;

public class IterableOfByteBuffersInputStream
extends InputStream {
    private final Iterator<ByteBuffer> buffers;
    private ByteBuffer currentBuffer;

    public IterableOfByteBuffersInputStream(Iterable<ByteBuffer> buffersIterable) {
        Objects.requireNonNull(buffersIterable, "'buffers' must not be null");
        this.buffers = buffersIterable.iterator();
    }

    @Override
    public synchronized int read() throws IOException {
        ByteBuffer buffer = this.getCurrentBuffer();
        if (buffer == null) {
            return -1;
        }
        return buffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int offset, int length) throws IOException {
        ByteBuffer buffer = this.getCurrentBuffer();
        if (buffer == null) {
            return -1;
        }
        int read = 0;
        while (length > 0 && buffer != null) {
            int toTransfer = Math.min(buffer.remaining(), length);
            buffer.get(b, offset, toTransfer);
            read += toTransfer;
            offset += toTransfer;
            length -= toTransfer;
            buffer = this.getCurrentBuffer();
        }
        return read;
    }

    @Override
    public synchronized int available() throws IOException {
        ByteBuffer buffer = this.getCurrentBuffer();
        if (buffer == null) {
            return 0;
        }
        return buffer.remaining();
    }

    private ByteBuffer getCurrentBuffer() {
        if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
            return this.currentBuffer;
        }
        while (this.buffers.hasNext()) {
            ByteBuffer copy;
            ByteBuffer candidate = this.buffers.next();
            if (!candidate.hasRemaining()) continue;
            this.currentBuffer = copy = candidate.duplicate();
            return copy;
        }
        return null;
    }
}

