/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling.Error;
import com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling.FinalResult;
import com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling.Util;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonProviders;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class AzureAsyncOperationData
implements JsonSerializable<AzureAsyncOperationData> {
    @JsonIgnore
    private static final ClientLogger LOGGER = new ClientLogger(AzureAsyncOperationData.class);
    @JsonProperty(value="lroRequestMethod", required=true)
    private HttpMethod lroRequestMethod;
    @JsonProperty(value="lroOperationUri", required=true)
    private URL lroOperationUri;
    @JsonProperty(value="pollUrl", required=true)
    private URL pollUrl;
    @JsonProperty(value="locationUrl")
    private URL locationUrl;
    @JsonProperty(value="provisioningState", required=true)
    private String provisioningState;
    @JsonProperty(value="pollError")
    private Error pollError;
    @JsonProperty(value="finalResult")
    private FinalResult finalResult;

    AzureAsyncOperationData() {
    }

    AzureAsyncOperationData(HttpMethod lroRequestMethod, URL lroOperationUri, URL pollUrl, URL locationUrl) {
        this.lroRequestMethod = Objects.requireNonNull(lroRequestMethod, "'lroRequestMethod' cannot be null.");
        this.lroOperationUri = Objects.requireNonNull(lroOperationUri, "'lroOperationUri' cannot be null.");
        this.pollUrl = Objects.requireNonNull(pollUrl, "'pollUrl' cannot be null.");
        this.locationUrl = locationUrl;
        this.provisioningState = "InProgress";
    }

    String getProvisioningState() {
        return this.provisioningState;
    }

    URL getPollUrl() {
        return this.pollUrl;
    }

    Error getPollError() {
        return this.pollError;
    }

    FinalResult getFinalResult() {
        return this.finalResult;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("lroRequestMethod", Objects.toString((Object)this.lroRequestMethod, null)).writeStringField("lroOperationUri", Objects.toString(this.lroOperationUri, null)).writeStringField("pollUrl", Objects.toString(this.pollUrl, null)).writeStringField("locationUrl", Objects.toString(this.locationUrl, null)).writeStringField("provisioningState", this.provisioningState).writeJsonField("pollError", this.pollError).writeJsonField("finalResult", this.finalResult).writeEndObject();
    }

    public static AzureAsyncOperationData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureAsyncOperationData azureAsyncOperationData = new AzureAsyncOperationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lroRequestMethod".equals(fieldName)) {
                    azureAsyncOperationData.lroRequestMethod = HttpMethod.valueOf(reader.getString());
                    continue;
                }
                if ("lroOperationUri".equals(fieldName)) {
                    azureAsyncOperationData.lroOperationUri = reader.getNullable(nonNullReader -> new URL(nonNullReader.getString()));
                    continue;
                }
                if ("pollUrl".equals(fieldName)) {
                    azureAsyncOperationData.pollUrl = reader.getNullable(nonNullReader -> new URL(nonNullReader.getString()));
                    continue;
                }
                if ("locationUrl".equals(fieldName)) {
                    azureAsyncOperationData.locationUrl = reader.getNullable(nonNullReader -> new URL(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    azureAsyncOperationData.provisioningState = reader.getString();
                    continue;
                }
                if ("pollError".equals(fieldName)) {
                    azureAsyncOperationData.pollError = Error.fromJson(reader);
                    continue;
                }
                if ("finalResult".equals(fieldName)) {
                    azureAsyncOperationData.finalResult = FinalResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return azureAsyncOperationData;
        });
    }

    void update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody) {
        if (pollResponseStatusCode != 200 && pollResponseStatusCode != 201 && pollResponseStatusCode != 202) {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling failed with status code:" + pollResponseStatusCode, pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            return;
        }
        AsyncOperationResource resource = AzureAsyncOperationData.tryParseAsyncOperationResource(pollResponseBody);
        if (resource == null || resource.getProvisioningState() == null) {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling response does not contain a valid body.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            return;
        }
        this.provisioningState = resource.getProvisioningState();
        if ("Failed".equalsIgnoreCase(this.provisioningState) || "Canceled".equalsIgnoreCase(this.provisioningState)) {
            this.pollError = new Error("Long running operation is Failed or Cancelled.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            return;
        }
        if ("Succeeded".equalsIgnoreCase(this.provisioningState)) {
            if (this.lroRequestMethod == HttpMethod.POST || this.lroRequestMethod == HttpMethod.DELETE) {
                if (this.locationUrl != null) {
                    this.finalResult = new FinalResult(this.locationUrl, null);
                }
            } else if (this.lroRequestMethod == HttpMethod.PUT || this.lroRequestMethod == HttpMethod.PATCH) {
                this.finalResult = new FinalResult(this.lroOperationUri, null);
            }
        } else {
            try {
                this.updateUrls(pollResponseHeaders);
            }
            catch (Util.MalformedUrlException mue) {
                this.provisioningState = "Failed";
                this.pollError = new Error("Long running operation contains a malformed Azure-AsyncOperation header.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            }
        }
    }

    private void updateUrls(HttpHeaders pollResponseHeaders) {
        URL locationUrl;
        URL azAsyncOpUrl = Util.getAzureAsyncOperationUrl(pollResponseHeaders, LOGGER);
        if (azAsyncOpUrl != null) {
            this.pollUrl = azAsyncOpUrl;
        }
        if ((locationUrl = Util.getLocationUrl(pollResponseHeaders, LOGGER, true)) != null) {
            this.locationUrl = locationUrl;
        }
    }

    private static AsyncOperationResource tryParseAsyncOperationResource(String value) {
        AsyncOperationResource asyncOperationResource;
        block9: {
            if (CoreUtils.isNullOrEmpty(value)) {
                return null;
            }
            JsonReader jsonReader = JsonProviders.createReader(value);
            try {
                asyncOperationResource = AsyncOperationResource.fromJson(jsonReader);
                if (jsonReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            jsonReader.close();
        }
        return asyncOperationResource;
    }

    private static class AsyncOperationResource
    implements JsonSerializable<AsyncOperationResource> {
        @JsonProperty(value="status")
        private String provisioningState;

        private AsyncOperationResource() {
        }

        private String getProvisioningState() {
            return this.provisioningState;
        }

        @Override
        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeStringField("status", this.provisioningState).writeEndObject();
        }

        public static AsyncOperationResource fromJson(JsonReader jsonReader) throws IOException {
            return jsonReader.readObject(reader -> {
                AsyncOperationResource asyncOperationResource = new AsyncOperationResource();
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("status".equals(fieldName)) {
                        asyncOperationResource.provisioningState = reader.getString();
                        continue;
                    }
                    reader.skipChildren();
                }
                return asyncOperationResource;
            });
        }
    }
}

