/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class FinalResult
implements JsonSerializable<FinalResult> {
    @JsonIgnore
    private static final ClientLogger LOGGER = new ClientLogger(FinalResult.class);
    @JsonProperty(value="resultUri")
    private URL resultUri;
    @JsonProperty(value="result")
    private String result;

    FinalResult() {
    }

    FinalResult(URL resultFetchUri, String result) {
        if (resultFetchUri == null && result == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Either resultFetchUri or result is required"));
        }
        this.resultUri = resultFetchUri;
        this.result = result;
    }

    URL getResultUri() {
        return this.resultUri;
    }

    String getResult() {
        return this.result;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("resultUri", Objects.toString(this.resultUri, null)).writeStringField("result", this.result).writeEndObject();
    }

    public static FinalResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FinalResult finalResult = new FinalResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resultUri".equals(fieldName)) {
                    finalResult.resultUri = reader.getNullable(nonNullReader -> new URL(nonNullReader.getString()));
                    continue;
                }
                if ("result".equals(fieldName)) {
                    finalResult.result = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return finalResult;
        });
    }
}

