/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.management.profile;

import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.models.AzureCloud;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class AzureProfile {
    private static final ClientLogger LOGGER = new ClientLogger(AzureProfile.class);
    private final String tenantId;
    private final String subscriptionId;
    private final AzureEnvironment environment;
    private static final Map<AzureCloud, AzureEnvironment> ENDPOINT_MAP = new HashMap<AzureCloud, AzureEnvironment>();

    public AzureProfile(AzureCloud azureCloud) {
        Objects.requireNonNull(azureCloud);
        this.environment = this.fromAzureCloud(azureCloud);
        Configuration configuration = Configuration.getGlobalConfiguration();
        this.tenantId = configuration.get("AZURE_TENANT_ID");
        this.subscriptionId = configuration.get("AZURE_SUBSCRIPTION_ID");
    }

    public AzureProfile(String tenantId, String subscriptionId, AzureCloud azureCloud) {
        Objects.requireNonNull(azureCloud);
        this.environment = this.fromAzureCloud(azureCloud);
        this.tenantId = tenantId;
        this.subscriptionId = subscriptionId;
    }

    public AzureProfile(AzureEnvironment environment) {
        Objects.requireNonNull(environment);
        this.environment = environment;
        Configuration configuration = Configuration.getGlobalConfiguration();
        this.tenantId = configuration.get("AZURE_TENANT_ID");
        this.subscriptionId = configuration.get("AZURE_SUBSCRIPTION_ID");
    }

    public AzureProfile(String tenantId, String subscriptionId, AzureEnvironment environment) {
        Objects.requireNonNull(environment);
        this.tenantId = tenantId;
        this.subscriptionId = subscriptionId;
        this.environment = environment;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    private AzureEnvironment fromAzureCloud(AzureCloud azureCloud) {
        AzureEnvironment azureEnvironment = ENDPOINT_MAP.get(azureCloud);
        if (azureEnvironment == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format("No endpoint mapping defined for AzureCloud: [%s].", azureCloud)));
        }
        return azureEnvironment;
    }

    static {
        ENDPOINT_MAP.put(AzureCloud.AZURE_PUBLIC_CLOUD, AzureEnvironment.AZURE);
        ENDPOINT_MAP.put(AzureCloud.AZURE_CHINA_CLOUD, AzureEnvironment.AZURE_CHINA);
        ENDPOINT_MAP.put(AzureCloud.AZURE_US_GOVERNMENT_CLOUD, AzureEnvironment.AZURE_US_GOVERNMENT);
    }
}

