/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.annotation.JsonCreator;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public final class DateTimeRfc1123 {
    private static final ClientLogger LOGGER = new ClientLogger(DateTimeRfc1123.class);
    private final OffsetDateTime dateTime;

    public DateTimeRfc1123(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTimeRfc1123(String formattedString) {
        this.dateTime = DateTimeRfc1123.parse(formattedString);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    @JsonCreator
    static DateTimeRfc1123 fromString(String date) {
        if (CoreUtils.isNullOrEmpty(date)) {
            return null;
        }
        return new DateTimeRfc1123(date);
    }

    private static OffsetDateTime parse(String date) {
        try {
            return OffsetDateTime.of(LocalDateTime.of(DateTimeRfc1123.parseInt(date, 12, 16), DateTimeRfc1123.parseMonth(date), DateTimeRfc1123.parseInt(date, 5, 7), DateTimeRfc1123.parseInt(date, 17, 19), DateTimeRfc1123.parseInt(date, 20, 22), DateTimeRfc1123.parseInt(date, 23, 25), 0), ZoneOffset.UTC);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | DateTimeException e) {
            return OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
        }
    }

    private static int parseInt(String date, int beginIndex, int endIndex) {
        int num = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = date.charAt(i);
            if (c < '0' || c > '9') {
                throw LOGGER.logExceptionAsError(new DateTimeException("Invalid date time: " + date));
            }
            num = num * 10 + (c - 48);
        }
        return num;
    }

    private static Month parseMonth(CharSequence date) {
        switch (date.charAt(8)) {
            case 'J': {
                switch (date.charAt(9)) {
                    case 'a': {
                        return Month.JANUARY;
                    }
                    case 'u': {
                        switch (date.charAt(10)) {
                            case 'n': {
                                return Month.JUNE;
                            }
                            case 'l': {
                                return Month.JULY;
                            }
                        }
                        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
            }
            case 'F': {
                return Month.FEBRUARY;
            }
            case 'M': {
                switch (date.charAt(10)) {
                    case 'r': {
                        return Month.MARCH;
                    }
                    case 'y': {
                        return Month.MAY;
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
            }
            case 'A': {
                switch (date.charAt(10)) {
                    case 'r': {
                        return Month.APRIL;
                    }
                    case 'g': {
                        return Month.AUGUST;
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
            }
            case 'S': {
                return Month.SEPTEMBER;
            }
            case 'O': {
                return Month.OCTOBER;
            }
            case 'N': {
                return Month.NOVEMBER;
            }
            case 'D': {
                return Month.DECEMBER;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
    }

    public static String toRfc1123String(OffsetDateTime dateTime) {
        dateTime = dateTime.withOffsetSameInstant(ZoneOffset.UTC);
        byte[] bytes = new byte[29];
        DayOfWeek dayOfWeek = dateTime.getDayOfWeek();
        switch (dayOfWeek) {
            case MONDAY: {
                bytes[0] = 77;
                bytes[1] = 111;
                bytes[2] = 110;
                break;
            }
            case TUESDAY: {
                bytes[0] = 84;
                bytes[1] = 117;
                bytes[2] = 101;
                break;
            }
            case WEDNESDAY: {
                bytes[0] = 87;
                bytes[1] = 101;
                bytes[2] = 100;
                break;
            }
            case THURSDAY: {
                bytes[0] = 84;
                bytes[1] = 104;
                bytes[2] = 117;
                break;
            }
            case FRIDAY: {
                bytes[0] = 70;
                bytes[1] = 114;
                bytes[2] = 105;
                break;
            }
            case SATURDAY: {
                bytes[0] = 83;
                bytes[1] = 97;
                bytes[2] = 116;
                break;
            }
            case SUNDAY: {
                bytes[0] = 83;
                bytes[1] = 117;
                bytes[2] = 110;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown day of week " + dayOfWeek));
            }
        }
        bytes[3] = 44;
        bytes[4] = 32;
        DateTimeRfc1123.zeroPad(dateTime.getDayOfMonth(), bytes, 5);
        bytes[7] = 32;
        Month month = dateTime.getMonth();
        switch (month) {
            case JANUARY: {
                bytes[8] = 74;
                bytes[9] = 97;
                bytes[10] = 110;
                break;
            }
            case FEBRUARY: {
                bytes[8] = 70;
                bytes[9] = 101;
                bytes[10] = 98;
                break;
            }
            case MARCH: {
                bytes[8] = 77;
                bytes[9] = 97;
                bytes[10] = 114;
                break;
            }
            case APRIL: {
                bytes[8] = 65;
                bytes[9] = 112;
                bytes[10] = 114;
                break;
            }
            case MAY: {
                bytes[8] = 77;
                bytes[9] = 97;
                bytes[10] = 121;
                break;
            }
            case JUNE: {
                bytes[8] = 74;
                bytes[9] = 117;
                bytes[10] = 110;
                break;
            }
            case JULY: {
                bytes[8] = 74;
                bytes[9] = 117;
                bytes[10] = 108;
                break;
            }
            case AUGUST: {
                bytes[8] = 65;
                bytes[9] = 117;
                bytes[10] = 103;
                break;
            }
            case SEPTEMBER: {
                bytes[8] = 83;
                bytes[9] = 101;
                bytes[10] = 112;
                break;
            }
            case OCTOBER: {
                bytes[8] = 79;
                bytes[9] = 99;
                bytes[10] = 116;
                break;
            }
            case NOVEMBER: {
                bytes[8] = 78;
                bytes[9] = 111;
                bytes[10] = 118;
                break;
            }
            case DECEMBER: {
                bytes[8] = 68;
                bytes[9] = 101;
                bytes[10] = 99;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + month));
            }
        }
        bytes[11] = 32;
        int year = dateTime.getYear();
        int round = year / 1000;
        bytes[12] = (byte)(48 + round);
        year -= 1000 * round;
        round = year / 100;
        bytes[13] = (byte)(48 + round);
        year -= 100 * round;
        round = year / 10;
        bytes[14] = (byte)(48 + round);
        bytes[15] = (byte)(48 + (year - 10 * round));
        bytes[16] = 32;
        DateTimeRfc1123.zeroPad(dateTime.getHour(), bytes, 17);
        bytes[19] = 58;
        DateTimeRfc1123.zeroPad(dateTime.getMinute(), bytes, 20);
        bytes[22] = 58;
        DateTimeRfc1123.zeroPad(dateTime.getSecond(), bytes, 23);
        bytes[25] = 32;
        bytes[26] = 71;
        bytes[27] = 77;
        bytes[28] = 84;
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void zeroPad(int value, byte[] bytes, int index) {
        if (value < 10) {
            bytes[index++] = 48;
            bytes[index] = (byte)(48 + value);
        } else {
            int high = value / 10;
            bytes[index++] = (byte)(48 + high);
            bytes[index] = (byte)(48 + (value - 10 * high));
        }
    }

    public String toString() {
        return DateTimeRfc1123.toRfc1123String(this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 rhs = (DateTimeRfc1123)obj;
        return this.dateTime.equals(rhs.getDateTime());
    }
}

