/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class QueryParameter {
    private static final String[] EMPTY_QUERY_PARAMETER_ARRAY = new String[0];
    private final String name;
    private String value;
    private List<String> values;
    private volatile String cachedStringValue;
    private static final AtomicReferenceFieldUpdater<QueryParameter, String> CACHED_STRING_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(QueryParameter.class, String.class, "cachedStringValue");

    QueryParameter(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.value = value;
    }

    QueryParameter(String name, List<String> values2) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(values2, "'values' cannot be null");
        this.name = name;
        int size = values2.size();
        if (size == 1) {
            this.value = values2.get(0);
        } else if (size != 0) {
            this.values = new ArrayList<String>(Math.max(size + 2, 4));
            this.values.addAll(values2);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (CoreUtils.isNullOrEmpty(this.values)) {
            return "";
        }
        this.checkCachedStringValue();
        return this.cachedStringValue;
    }

    public String[] getValues() {
        if (this.value != null) {
            return new String[]{this.value};
        }
        if (!CoreUtils.isNullOrEmpty(this.values)) {
            return this.values.toArray(new String[0]);
        }
        return EMPTY_QUERY_PARAMETER_ARRAY;
    }

    public List<String> getValuesList() {
        if (this.value != null) {
            return Collections.singletonList(this.value);
        }
        if (!CoreUtils.isNullOrEmpty(this.values)) {
            return Collections.unmodifiableList(this.values);
        }
        return Collections.emptyList();
    }

    public void addValue(String value) {
        if (this.value == null && this.values == null) {
            this.value = value;
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList<String>(4);
            this.values.add(this.value);
            this.value = null;
        }
        this.values.add(value);
        CACHED_STRING_VALUE_UPDATER.set(this, null);
    }

    public String toString() {
        if (this.value != null) {
            return this.name + "=" + this.value;
        }
        if (CoreUtils.isNullOrEmpty(this.values)) {
            return "";
        }
        this.checkCachedStringValue();
        return this.name + "=" + CACHED_STRING_VALUE_UPDATER.get(this);
    }

    private void checkCachedStringValue() {
        CACHED_STRING_VALUE_UPDATER.compareAndSet(this, null, CoreUtils.stringJoin(",", this.values));
    }
}

