/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlToken;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlTokenizerState;

class UrlTokenizer {
    private final String text;
    private final int textLength;
    private UrlTokenizerState state;
    private int currentIndex;
    private UrlToken currentToken;

    UrlTokenizer(String text) {
        this(text, UrlTokenizerState.SCHEME_OR_HOST);
    }

    UrlTokenizer(String text, UrlTokenizerState state) {
        this.text = text;
        this.textLength = text == null ? 0 : text.length();
        this.state = state;
        this.currentIndex = 0;
        this.currentToken = null;
    }

    private boolean hasCurrentCharacter() {
        return this.currentIndex < this.textLength;
    }

    private char currentCharacter() {
        return this.text.charAt(this.currentIndex);
    }

    private void nextCharacter() {
        if (this.hasCurrentCharacter()) {
            ++this.currentIndex;
        }
    }

    private boolean peekMatchesSchemeSeparator(boolean step) {
        if ("://".regionMatches(0, this.text, this.currentIndex, 3)) {
            if (step) {
                this.currentIndex += 3;
            }
            return true;
        }
        return false;
    }

    UrlToken current() {
        return this.currentToken;
    }

    boolean next() {
        if (!this.hasCurrentCharacter()) {
            this.currentToken = null;
        } else {
            switch (this.state) {
                case SCHEME: {
                    String scheme = this.readUntilNotLetterOrDigit();
                    this.currentToken = UrlToken.scheme(scheme);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    this.state = UrlTokenizerState.HOST;
                    break;
                }
                case SCHEME_OR_HOST: {
                    String schemeOrHost = this.readUntil(true);
                    if (!this.hasCurrentCharacter()) {
                        this.currentToken = UrlToken.host(schemeOrHost);
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    char c = this.currentCharacter();
                    if (c == ':') {
                        if (this.peekMatchesSchemeSeparator(false)) {
                            this.currentToken = UrlToken.scheme(schemeOrHost);
                            this.state = UrlTokenizerState.HOST;
                            break;
                        }
                        this.currentToken = UrlToken.host(schemeOrHost);
                        this.state = UrlTokenizerState.PORT;
                        break;
                    }
                    if (c == '/') {
                        this.currentToken = UrlToken.host(schemeOrHost);
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    if (c != '?') break;
                    this.currentToken = UrlToken.host(schemeOrHost);
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case HOST: {
                    this.peekMatchesSchemeSeparator(true);
                    String host = this.readUntil(true);
                    this.currentToken = UrlToken.host(host);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    char c = this.currentCharacter();
                    if (c == ':') {
                        this.state = UrlTokenizerState.PORT;
                        break;
                    }
                    if (c == '/') {
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case PORT: {
                    char c = this.currentCharacter();
                    if (c == ':') {
                        this.nextCharacter();
                    }
                    String port = this.readUntil(false);
                    this.currentToken = UrlToken.port(port);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    if (this.currentCharacter() == '/') {
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case PATH: {
                    String path;
                    int index = this.text.indexOf(63, this.currentIndex);
                    if (index == -1) {
                        path = this.text.substring(this.currentIndex);
                        this.currentIndex = this.textLength;
                    } else {
                        path = this.text.substring(this.currentIndex, index);
                        this.currentIndex = index;
                    }
                    this.currentToken = UrlToken.path(path);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case QUERY: {
                    if (this.currentCharacter() == '?') {
                        this.nextCharacter();
                    }
                    String query = this.readRemaining();
                    this.currentToken = UrlToken.query(query);
                    this.state = UrlTokenizerState.DONE;
                    break;
                }
            }
        }
        return this.currentToken != null;
    }

    private String readUntilNotLetterOrDigit() {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int start = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char currentCharacter = this.currentCharacter();
            if (!Character.isLetterOrDigit(currentCharacter)) {
                return this.text.substring(start, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(start);
    }

    private String readUntil(boolean checkForColon) {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int start = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char c = this.currentCharacter();
            if (checkForColon && c == ':' || c == '/' || c == '?') {
                return this.text.substring(start, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(start);
    }

    private String readRemaining() {
        String result = "";
        if (this.currentIndex < this.textLength) {
            result = this.text.substring(this.currentIndex, this.textLength);
            this.currentIndex = this.textLength;
        }
        return result;
    }
}

