/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.TypeReference;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ChainedPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(ChainedPollingStrategy.class);
    private final List<PollingStrategy<T, U>> pollingStrategies;
    private PollingStrategy<T, U> pollableStrategy = null;

    public ChainedPollingStrategy(List<PollingStrategy<T, U>> strategies) {
        Objects.requireNonNull(strategies, "'strategies' cannot be null.");
        if (strategies.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'strategies' cannot be empty."));
        }
        this.pollingStrategies = Collections.unmodifiableList(strategies);
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        return Flux.fromIterable(this.pollingStrategies).concatMap(strategy -> strategy.canPoll(initialResponse).map(canPoll -> Tuples.of(strategy, canPoll))).takeUntil(Tuple2::getT2).last().map(tuple2 -> {
            this.pollableStrategy = (PollingStrategy)tuple2.getT1();
            return true;
        }).defaultIfEmpty(false);
    }

    @Override
    public Mono<U> getResult(PollingContext<T> context, TypeReference<U> resultType) {
        return this.pollableStrategy.getResult(context, resultType);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        return this.pollableStrategy.onInitialResponse(response, pollingContext, pollResponseType);
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> context, TypeReference<T> pollResponseType) {
        return this.pollableStrategy.poll(context, pollResponseType);
    }

    @Override
    public Mono<T> cancel(PollingContext<T> pollingContext, PollResponse<T> initialResponse) {
        return this.pollableStrategy.cancel(pollingContext, initialResponse);
    }
}

