/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.serializer;

import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.MemberNameConverter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.MemberNameConverterProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class MemberNameConverterProviders {
    private static final String CANNOT_FIND_MEMBER_NAME_CONVERTER_PROVIDER = "Cannot find any member name converter provider on the classpath.";
    private static MemberNameConverterProvider defaultProvider;
    private static boolean attemptedLoad;

    public static MemberNameConverter createInstance() {
        if (defaultProvider == null) {
            MemberNameConverterProviders.loadFromClasspath();
        }
        return defaultProvider.createInstance();
    }

    private static synchronized void loadFromClasspath() {
        if (attemptedLoad && defaultProvider != null) {
            return;
        }
        if (attemptedLoad) {
            throw new IllegalStateException(CANNOT_FIND_MEMBER_NAME_CONVERTER_PROVIDER);
        }
        attemptedLoad = true;
        Iterator<MemberNameConverterProvider> iterator2 = ServiceLoader.load(MemberNameConverterProvider.class, MemberNameConverterProviders.class.getClassLoader()).iterator();
        if (!iterator2.hasNext()) {
            throw new IllegalStateException(CANNOT_FIND_MEMBER_NAME_CONVERTER_PROVIDER);
        }
        defaultProvider = iterator2.next();
    }

    private MemberNameConverterProviders() {
    }
}

