/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.ClientAuthenticationException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.WorkloadIdentityCredential;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ChainedTokenCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ChainedTokenCredential.class);
    private final List<TokenCredential> credentials;
    private final String unavailableError = this.getClass().getSimpleName() + " authentication failed. ---> ";
    private final AtomicReference<TokenCredential> selectedCredential;
    private boolean useCachedWorkingCredential = false;

    ChainedTokenCredential(List<TokenCredential> credentials) {
        this.credentials = Collections.unmodifiableList(credentials);
        this.selectedCredential = new AtomicReference();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        ArrayList exceptions = new ArrayList(4);
        Mono<Object> accessTokenMono = this.selectedCredential.get() != null && this.useCachedWorkingCredential ? Mono.defer(() -> this.selectedCredential.get().getToken(request).doOnNext(t -> this.logTokenMessage("Azure Identity => Returning token from cached credential {}", this.selectedCredential.get())).onErrorResume(Exception.class, this.handleExceptionAsync(exceptions, this.selectedCredential.get(), "Azure Identity => Cached credential {} is unavailable."))) : Flux.fromIterable(this.credentials).flatMap(p -> p.getToken(request).doOnNext(t -> {
            this.logTokenMessage("Azure Identity => Attempted credential {} returns a token", (TokenCredential)p);
            this.selectedCredential.set((TokenCredential)p);
        }).onErrorResume(Exception.class, this.handleExceptionAsync(exceptions, (TokenCredential)p, "Azure Identity => Attempted credential {} is unavailable.")), 1).next();
        return accessTokenMono.switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException last = (CredentialUnavailableException)exceptions.get(exceptions.size() - 1);
            for (int z = exceptions.size() - 2; z >= 0; --z) {
                CredentialUnavailableException current = (CredentialUnavailableException)exceptions.get(z);
                last = new CredentialUnavailableException(current.getMessage() + "\r\n" + last.getMessage() + (z == 0 ? "To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot" : ""));
            }
            return Mono.error(last);
        }));
    }

    private Function<Exception, Mono<? extends AccessToken>> handleExceptionAsync(List<CredentialUnavailableException> exceptions, TokenCredential p, String logMessage) {
        return t -> {
            if (!t.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error(new ClientAuthenticationException(this.getCredUnavailableMessage(p, (Exception)t), null, (Throwable)t));
            }
            exceptions.add((CredentialUnavailableException)t);
            this.logTokenMessage(logMessage, p);
            return Mono.empty();
        };
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        ArrayList<CredentialUnavailableException> exceptions = new ArrayList<CredentialUnavailableException>(4);
        if (this.selectedCredential.get() != null && this.useCachedWorkingCredential) {
            try {
                AccessToken accessToken = this.selectedCredential.get().getTokenSync(request);
                this.logTokenMessage("Azure Identity => Returning token from cached credential {}", this.selectedCredential.get());
                return accessToken;
            }
            catch (Exception e) {
                this.handleExceptionSync(e, this.selectedCredential.get(), exceptions, "Azure Identity => Cached credential {} is unavailable.", this.selectedCredential.get());
            }
        } else {
            for (TokenCredential credential : this.credentials) {
                try {
                    AccessToken accessToken = credential.getTokenSync(request);
                    this.logTokenMessage("Azure Identity => Attempted credential {} returns a token", credential);
                    this.selectedCredential.set(credential);
                    return accessToken;
                }
                catch (Exception e) {
                    this.handleExceptionSync(e, credential, exceptions, "Azure Identity => Attempted credential {} is unavailable.", credential);
                }
            }
        }
        CredentialUnavailableException last = (CredentialUnavailableException)exceptions.get(exceptions.size() - 1);
        for (int z = exceptions.size() - 2; z >= 0; --z) {
            CredentialUnavailableException current = (CredentialUnavailableException)exceptions.get(z);
            last = new CredentialUnavailableException(current.getMessage() + "\r\n" + last.getMessage() + (z == 0 ? "To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot" : ""));
        }
        throw last;
    }

    private void logTokenMessage(String format, TokenCredential selectedCredential) {
        LOGGER.info(format, selectedCredential.getClass().getSimpleName());
    }

    private String getCredUnavailableMessage(TokenCredential p, Exception t) {
        return this.unavailableError + p.getClass().getSimpleName() + " authentication failed. Error Details: " + t.getMessage();
    }

    private void handleExceptionSync(Exception e, TokenCredential selectedCredential, List<CredentialUnavailableException> exceptions, String logMessage, TokenCredential selectedCredential1) {
        if (e.getClass() != CredentialUnavailableException.class) {
            throw new ClientAuthenticationException(this.getCredUnavailableMessage(selectedCredential, e), null, e);
        }
        if (e instanceof CredentialUnavailableException) {
            exceptions.add((CredentialUnavailableException)e);
        }
        this.logTokenMessage(logMessage, selectedCredential1);
    }

    WorkloadIdentityCredential getWorkloadIdentityCredentialIfPresent() {
        List tokenCredentials = this.credentials.stream().filter(tokenCredential -> tokenCredential instanceof WorkloadIdentityCredential).collect(Collectors.toList());
        if (tokenCredentials.size() == 1) {
            return (WorkloadIdentityCredential)tokenCredentials.get(0);
        }
        return null;
    }

    void enableUseCachedWorkingCredential() {
        this.useCachedWorkingCredential = true;
    }
}

