/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.json;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonProviders;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.json.implementation.StringBuilderWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public interface JsonSerializable<T extends JsonSerializable<T>> {
    public JsonWriter toJson(JsonWriter var1) throws IOException;

    default public void toJson(OutputStream outputStream2) throws IOException {
        try (JsonWriter jsonWriter = JsonProviders.createWriter(outputStream2);){
            this.toJson(jsonWriter).flush();
        }
    }

    default public void toJson(Writer writer) throws IOException {
        try (JsonWriter jsonWriter = JsonProviders.createWriter(writer);){
            this.toJson(jsonWriter).flush();
        }
    }

    default public String toJsonString() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        try (JsonWriter jsonWriter = JsonProviders.createWriter(writer);){
            this.toJson(jsonWriter).flush();
            String string = writer.toString();
            return string;
        }
    }

    default public byte[] toJsonBytes() throws IOException {
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = JsonProviders.createWriter(outputStream2);){
            this.toJson(jsonWriter).flush();
            byte[] byArray = outputStream2.toByteArray();
            return byArray;
        }
    }

    public static <T extends JsonSerializable<T>> T fromJson(JsonReader jsonReader) throws IOException {
        throw new UnsupportedOperationException("Implementation of JsonSerializable must define this factory method.");
    }

    public static <T extends JsonSerializable<T>> T fromJson(String string) throws IOException {
        try (JsonReader jsonReader = JsonProviders.createReader(string);){
            T t = JsonSerializable.fromJson(jsonReader);
            return t;
        }
    }

    public static <T extends JsonSerializable<T>> T fromJson(byte[] bytes) throws IOException {
        try (JsonReader jsonReader = JsonProviders.createReader(bytes);){
            T t = JsonSerializable.fromJson(jsonReader);
            return t;
        }
    }

    public static <T extends JsonSerializable<T>> T fromJson(InputStream inputStream2) throws IOException {
        try (JsonReader jsonReader = JsonProviders.createReader(inputStream2);){
            T t = JsonSerializable.fromJson(jsonReader);
            return t;
        }
    }

    public static <T extends JsonSerializable<T>> T fromJson(Reader reader) throws IOException {
        try (JsonReader jsonReader = JsonProviders.createReader(reader);){
            T t = JsonSerializable.fromJson(jsonReader);
            return t;
        }
    }
}

