/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.CustomDomainsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.CustomDomainResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.CustomDomainResourceCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class CustomDomainsClientImpl
implements CustomDomainsClient {
    private final CustomDomainsService service;
    private final AppPlatformManagementClientImpl client;

    CustomDomainsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(CustomDomainsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CustomDomainResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CustomDomainResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> getAsync(String resourceGroupName, String serviceName, String appName, String domainName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, appName, domainName).flatMap(res -> Mono.justOrEmpty((CustomDomainResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomDomainResourceInner> getWithResponse(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, appName, domainName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainResourceInner get(String resourceGroupName, String serviceName, String appName, String domainName) {
        return this.getWithResponse(resourceGroupName, serviceName, appName, domainName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (domainResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainResource is required and cannot be null."));
        }
        domainResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, domainResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (domainResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainResource is required and cannot be null."));
        }
        domainResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, domainResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, domainResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainResourceInner.class), (Type)((Object)CustomDomainResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainResourceInner.class), (Type)((Object)CustomDomainResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainResourceInner createOrUpdate(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainResourceInner createOrUpdate(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String appName, String domainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, appName, domainName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, appName, domainName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String appName, String domainName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, domainName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, domainName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName, String domainName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, domainName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, domainName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName, String domainName) {
        this.deleteAsync(resourceGroupName, serviceName, appName, domainName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName, String domainName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, appName, domainName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (domainResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainResource is required and cannot be null."));
        }
        domainResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, domainResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (domainResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainResource is required and cannot be null."));
        }
        domainResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, domainName, domainResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, domainResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainResourceInner.class), (Type)((Object)CustomDomainResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CustomDomainResourceInner.class), (Type)((Object)CustomDomainResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdate(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomDomainResourceInner>, CustomDomainResourceInner> beginUpdate(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomDomainResourceInner> updateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomDomainResourceInner> updateAsync(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainResourceInner update(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource) {
        return this.updateAsync(resourceGroupName, serviceName, appName, domainName, domainResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomDomainResourceInner update(String resourceGroupName, String serviceName, String appName, String domainName, CustomDomainResourceInner domainResource, Context context) {
        return this.updateAsync(resourceGroupName, serviceName, appName, domainName, domainResource, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String appName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, CustomDomainResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainResourceCollection)res.getValue()).value(), ((CustomDomainResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String appName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error(new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, "application/json", context).map(res -> new PagedResponseBase<Object, CustomDomainResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainResourceCollection)res.getValue()).value(), ((CustomDomainResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CustomDomainResourceInner> listAsync(String resourceGroupName, String serviceName, String appName) {
        return new PagedFlux<CustomDomainResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, appName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CustomDomainResourceInner> listAsync(String resourceGroupName, String serviceName, String appName, Context context) {
        return new PagedFlux<CustomDomainResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, appName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomDomainResourceInner> list(String resourceGroupName, String serviceName, String appName) {
        return new PagedIterable<CustomDomainResourceInner>(this.listAsync(resourceGroupName, serviceName, appName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomDomainResourceInner> list(String resourceGroupName, String serviceName, String appName, Context context) {
        return new PagedIterable<CustomDomainResourceInner>(this.listAsync(resourceGroupName, serviceName, appName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, CustomDomainResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainResourceCollection)res.getValue()).value(), ((CustomDomainResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomDomainResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, CustomDomainResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomDomainResourceCollection)res.getValue()).value(), ((CustomDomainResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface CustomDomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="domainName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="domainName") String var7, @BodyParam(value="application/json") CustomDomainResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="domainName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains/{domainName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="domainName") String var7, @BodyParam(value="application/json") CustomDomainResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomDomainResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

