/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ImageRegistryCredential;
import java.io.IOException;
import java.util.List;

public final class CustomContainer
implements JsonSerializable<CustomContainer> {
    private String server;
    private String containerImage;
    private List<String> command;
    private List<String> args;
    private ImageRegistryCredential imageRegistryCredential;
    private String languageFramework;

    public String server() {
        return this.server;
    }

    public CustomContainer withServer(String server) {
        this.server = server;
        return this;
    }

    public String containerImage() {
        return this.containerImage;
    }

    public CustomContainer withContainerImage(String containerImage) {
        this.containerImage = containerImage;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public CustomContainer withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<String> args() {
        return this.args;
    }

    public CustomContainer withArgs(List<String> args2) {
        this.args = args2;
        return this;
    }

    public ImageRegistryCredential imageRegistryCredential() {
        return this.imageRegistryCredential;
    }

    public CustomContainer withImageRegistryCredential(ImageRegistryCredential imageRegistryCredential) {
        this.imageRegistryCredential = imageRegistryCredential;
        return this;
    }

    public String languageFramework() {
        return this.languageFramework;
    }

    public CustomContainer withLanguageFramework(String languageFramework) {
        this.languageFramework = languageFramework;
        return this;
    }

    public void validate() {
        if (this.imageRegistryCredential() != null) {
            this.imageRegistryCredential().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("containerImage", this.containerImage);
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("args", this.args, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("imageRegistryCredential", this.imageRegistryCredential);
        jsonWriter.writeStringField("languageFramework", this.languageFramework);
        return jsonWriter.writeEndObject();
    }

    public static CustomContainer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomContainer deserializedCustomContainer = new CustomContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedCustomContainer.server = reader.getString();
                    continue;
                }
                if ("containerImage".equals(fieldName)) {
                    deserializedCustomContainer.containerImage = reader.getString();
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List<String> command = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomContainer.command = command;
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List<String> args2 = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomContainer.args = args2;
                    continue;
                }
                if ("imageRegistryCredential".equals(fieldName)) {
                    deserializedCustomContainer.imageRegistryCredential = ImageRegistryCredential.fromJson(reader);
                    continue;
                }
                if ("languageFramework".equals(fieldName)) {
                    deserializedCustomContainer.languageFramework = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomContainer;
        });
    }
}

