/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class GitPatternRepository
implements JsonSerializable<GitPatternRepository> {
    private String name;
    private List<String> pattern;
    private String uri;
    private String label;
    private List<String> searchPaths;
    private String username;
    private String password;
    private String hostKey;
    private String hostKeyAlgorithm;
    private String privateKey;
    private Boolean strictHostKeyChecking;
    private static final ClientLogger LOGGER = new ClientLogger(GitPatternRepository.class);

    public String name() {
        return this.name;
    }

    public GitPatternRepository withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> pattern() {
        return this.pattern;
    }

    public GitPatternRepository withPattern(List<String> pattern) {
        this.pattern = pattern;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public GitPatternRepository withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String label() {
        return this.label;
    }

    public GitPatternRepository withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> searchPaths() {
        return this.searchPaths;
    }

    public GitPatternRepository withSearchPaths(List<String> searchPaths) {
        this.searchPaths = searchPaths;
        return this;
    }

    public String username() {
        return this.username;
    }

    public GitPatternRepository withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public GitPatternRepository withPassword(String password) {
        this.password = password;
        return this;
    }

    public String hostKey() {
        return this.hostKey;
    }

    public GitPatternRepository withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public GitPatternRepository withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public GitPatternRepository withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Boolean strictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public GitPatternRepository withStrictHostKeyChecking(Boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model GitPatternRepository"));
        }
        if (this.uri() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property uri in model GitPatternRepository"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeArrayField("pattern", this.pattern, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("searchPaths", this.searchPaths, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("hostKey", this.hostKey);
        jsonWriter.writeStringField("hostKeyAlgorithm", this.hostKeyAlgorithm);
        jsonWriter.writeStringField("privateKey", this.privateKey);
        jsonWriter.writeBooleanField("strictHostKeyChecking", this.strictHostKeyChecking);
        return jsonWriter.writeEndObject();
    }

    public static GitPatternRepository fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GitPatternRepository deserializedGitPatternRepository = new GitPatternRepository();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGitPatternRepository.name = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedGitPatternRepository.uri = reader.getString();
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    List<String> pattern = reader.readArray(reader1 -> reader1.getString());
                    deserializedGitPatternRepository.pattern = pattern;
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedGitPatternRepository.label = reader.getString();
                    continue;
                }
                if ("searchPaths".equals(fieldName)) {
                    List<String> searchPaths = reader.readArray(reader1 -> reader1.getString());
                    deserializedGitPatternRepository.searchPaths = searchPaths;
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedGitPatternRepository.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedGitPatternRepository.password = reader.getString();
                    continue;
                }
                if ("hostKey".equals(fieldName)) {
                    deserializedGitPatternRepository.hostKey = reader.getString();
                    continue;
                }
                if ("hostKeyAlgorithm".equals(fieldName)) {
                    deserializedGitPatternRepository.hostKeyAlgorithm = reader.getString();
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedGitPatternRepository.privateKey = reader.getString();
                    continue;
                }
                if ("strictHostKeyChecking".equals(fieldName)) {
                    deserializedGitPatternRepository.strictHostKeyChecking = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGitPatternRepository;
        });
    }
}

