/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ResourceSkuLocationInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ResourceSkuRestrictions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SkuCapacity;
import java.io.IOException;
import java.util.List;

public final class ResourceSku
implements JsonSerializable<ResourceSku> {
    private String resourceType;
    private String name;
    private String tier;
    private SkuCapacity capacity;
    private List<String> locations;
    private List<ResourceSkuLocationInfo> locationInfo;
    private List<ResourceSkuRestrictions> restrictions;

    public String resourceType() {
        return this.resourceType;
    }

    public ResourceSku withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ResourceSku withName(String name) {
        this.name = name;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public ResourceSku withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public SkuCapacity capacity() {
        return this.capacity;
    }

    public ResourceSku withCapacity(SkuCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ResourceSku withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<ResourceSkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    public ResourceSku withLocationInfo(List<ResourceSkuLocationInfo> locationInfo) {
        this.locationInfo = locationInfo;
        return this;
    }

    public List<ResourceSkuRestrictions> restrictions() {
        return this.restrictions;
    }

    public ResourceSku withRestrictions(List<ResourceSkuRestrictions> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public void validate() {
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeJsonField("capacity", this.capacity);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("locationInfo", this.locationInfo, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("restrictions", this.restrictions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSku deserializedResourceSku = new ResourceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceSku.resourceType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceSku.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedResourceSku.tier = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedResourceSku.capacity = SkuCapacity.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSku.locations = locations;
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List<ResourceSkuLocationInfo> locationInfo = reader.readArray(reader1 -> ResourceSkuLocationInfo.fromJson(reader1));
                    deserializedResourceSku.locationInfo = locationInfo;
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List<ResourceSkuRestrictions> restrictions = reader.readArray(reader1 -> ResourceSkuRestrictions.fromJson(reader1));
                    deserializedResourceSku.restrictions = restrictions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSku;
        });
    }
}

