/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServiceCertificateOrdersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServiceCertificatesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServiceDomainsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServicePlansImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.FunctionAppsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebAppsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificateOrders;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificates;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceDomains;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServicePlans;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionApps;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebApps;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.DnsZoneManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import java.util.Objects;

public final class AppServiceManager
extends Manager<WebSiteManagementClient> {
    private final AuthorizationManager authorizationManager;
    private final KeyVaultManager keyVaultManager;
    private final StorageManager storageManager;
    private final DnsZoneManager dnsZoneManager;
    private WebApps webApps;
    private AppServicePlans appServicePlans;
    private AppServiceCertificateOrders appServiceCertificateOrders;
    private AppServiceCertificates appServiceCertificates;
    private AppServiceDomains appServiceDomains;
    private FunctionApps functionApps;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static AppServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return AppServiceManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static AppServiceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AppServiceManager(httpPipeline, profile);
    }

    private AppServiceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new WebSiteManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.keyVaultManager = KeyVaultManager.authenticate(httpPipeline, profile);
        this.storageManager = StorageManager.authenticate(httpPipeline, profile);
        this.authorizationManager = AuthorizationManager.authenticate(httpPipeline, profile);
        this.dnsZoneManager = DnsZoneManager.authenticate(httpPipeline, profile);
    }

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    public KeyVaultManager keyVaultManager() {
        return this.keyVaultManager;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public DnsZoneManager dnsZoneManager() {
        return this.dnsZoneManager;
    }

    public WebApps webApps() {
        if (this.webApps == null) {
            this.webApps = new WebAppsImpl(this);
        }
        return this.webApps;
    }

    public AppServicePlans appServicePlans() {
        if (this.appServicePlans == null) {
            this.appServicePlans = new AppServicePlansImpl(this);
        }
        return this.appServicePlans;
    }

    public AppServiceCertificateOrders certificateOrders() {
        if (this.appServiceCertificateOrders == null) {
            this.appServiceCertificateOrders = new AppServiceCertificateOrdersImpl(this);
        }
        return this.appServiceCertificateOrders;
    }

    public AppServiceCertificates certificates() {
        if (this.appServiceCertificates == null) {
            this.appServiceCertificates = new AppServiceCertificatesImpl(this);
        }
        return this.appServiceCertificates;
    }

    public AppServiceDomains domains() {
        if (this.appServiceDomains == null) {
            this.appServiceDomains = new AppServiceDomainsImpl(this);
        }
        return this.appServiceDomains;
    }

    public FunctionApps functionApps() {
        if (this.functionApps == null) {
            this.functionApps = new FunctionAppsImpl(this);
        }
        return this.functionApps;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public AppServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
            return AppServiceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public AppServiceManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

