/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class BackupItemProperties
implements JsonSerializable<BackupItemProperties> {
    private Integer backupId;
    private String storageAccountUrl;
    private String blobName;
    private String name;
    private BackupItemStatus status;
    private Long sizeInBytes;
    private OffsetDateTime created;
    private String log;
    private List<DatabaseBackupSetting> databases;
    private Boolean scheduled;
    private OffsetDateTime lastRestoreTimestamp;
    private OffsetDateTime finishedTimestamp;
    private String correlationId;
    private Long websiteSizeInBytes;

    public Integer backupId() {
        return this.backupId;
    }

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public String blobName() {
        return this.blobName;
    }

    public String name() {
        return this.name;
    }

    public BackupItemStatus status() {
        return this.status;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public OffsetDateTime created() {
        return this.created;
    }

    public String log() {
        return this.log;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public Boolean scheduled() {
        return this.scheduled;
    }

    public OffsetDateTime lastRestoreTimestamp() {
        return this.lastRestoreTimestamp;
    }

    public OffsetDateTime finishedTimestamp() {
        return this.finishedTimestamp;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public Long websiteSizeInBytes() {
        return this.websiteSizeInBytes;
    }

    public void validate() {
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static BackupItemProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupItemProperties deserializedBackupItemProperties = new BackupItemProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupItemProperties.backupId = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageAccountUrl".equals(fieldName)) {
                    deserializedBackupItemProperties.storageAccountUrl = reader.getString();
                    continue;
                }
                if ("blobName".equals(fieldName)) {
                    deserializedBackupItemProperties.blobName = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupItemProperties.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedBackupItemProperties.status = BackupItemStatus.fromString(reader.getString());
                    continue;
                }
                if ("sizeInBytes".equals(fieldName)) {
                    deserializedBackupItemProperties.sizeInBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedBackupItemProperties.created = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("log".equals(fieldName)) {
                    deserializedBackupItemProperties.log = reader.getString();
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List<DatabaseBackupSetting> databases = reader.readArray(reader1 -> DatabaseBackupSetting.fromJson(reader1));
                    deserializedBackupItemProperties.databases = databases;
                    continue;
                }
                if ("scheduled".equals(fieldName)) {
                    deserializedBackupItemProperties.scheduled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastRestoreTimeStamp".equals(fieldName)) {
                    deserializedBackupItemProperties.lastRestoreTimestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("finishedTimeStamp".equals(fieldName)) {
                    deserializedBackupItemProperties.finishedTimestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedBackupItemProperties.correlationId = reader.getString();
                    continue;
                }
                if ("websiteSizeInBytes".equals(fieldName)) {
                    deserializedBackupItemProperties.websiteSizeInBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupItemProperties;
        });
    }
}

