/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DetectorAbnormalTimePeriod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DiagnosticMetricSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.NameValuePair;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResponseMetadata;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DiagnosticDetectorResponseProperties
implements JsonSerializable<DiagnosticDetectorResponseProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Boolean issueDetected;
    private DetectorDefinition detectorDefinition;
    private List<DiagnosticMetricSet> metrics;
    private List<DetectorAbnormalTimePeriod> abnormalTimePeriods;
    private List<List<NameValuePair>> data;
    private ResponseMetadata responseMetadata;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public DiagnosticDetectorResponseProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public DiagnosticDetectorResponseProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Boolean issueDetected() {
        return this.issueDetected;
    }

    public DiagnosticDetectorResponseProperties withIssueDetected(Boolean issueDetected) {
        this.issueDetected = issueDetected;
        return this;
    }

    public DetectorDefinition detectorDefinition() {
        return this.detectorDefinition;
    }

    public DiagnosticDetectorResponseProperties withDetectorDefinition(DetectorDefinition detectorDefinition) {
        this.detectorDefinition = detectorDefinition;
        return this;
    }

    public List<DiagnosticMetricSet> metrics() {
        return this.metrics;
    }

    public DiagnosticDetectorResponseProperties withMetrics(List<DiagnosticMetricSet> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<DetectorAbnormalTimePeriod> abnormalTimePeriods() {
        return this.abnormalTimePeriods;
    }

    public DiagnosticDetectorResponseProperties withAbnormalTimePeriods(List<DetectorAbnormalTimePeriod> abnormalTimePeriods) {
        this.abnormalTimePeriods = abnormalTimePeriods;
        return this;
    }

    public List<List<NameValuePair>> data() {
        return this.data;
    }

    public DiagnosticDetectorResponseProperties withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    public ResponseMetadata responseMetadata() {
        return this.responseMetadata;
    }

    public DiagnosticDetectorResponseProperties withResponseMetadata(ResponseMetadata responseMetadata) {
        this.responseMetadata = responseMetadata;
        return this;
    }

    public void validate() {
        if (this.detectorDefinition() != null) {
            this.detectorDefinition().validate();
        }
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
        if (this.abnormalTimePeriods() != null) {
            this.abnormalTimePeriods().forEach(e -> e.validate());
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.responseMetadata() != null) {
            this.responseMetadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeBooleanField("issueDetected", this.issueDetected);
        jsonWriter.writeJsonField("detectorDefinition", this.detectorDefinition);
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("abnormalTimePeriods", this.abnormalTimePeriods, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson((JsonSerializable<?>)element1)));
        jsonWriter.writeJsonField("responseMetaData", this.responseMetadata);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticDetectorResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticDetectorResponseProperties deserializedDiagnosticDetectorResponseProperties = new DiagnosticDetectorResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseProperties.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("issueDetected".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseProperties.issueDetected = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("detectorDefinition".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseProperties.detectorDefinition = DetectorDefinition.fromJson(reader);
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List<DiagnosticMetricSet> metrics = reader.readArray(reader1 -> DiagnosticMetricSet.fromJson(reader1));
                    deserializedDiagnosticDetectorResponseProperties.metrics = metrics;
                    continue;
                }
                if ("abnormalTimePeriods".equals(fieldName)) {
                    List<DetectorAbnormalTimePeriod> abnormalTimePeriods = reader.readArray(reader1 -> DetectorAbnormalTimePeriod.fromJson(reader1));
                    deserializedDiagnosticDetectorResponseProperties.abnormalTimePeriods = abnormalTimePeriods;
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List<List> data = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedDiagnosticDetectorResponseProperties.data = data;
                    continue;
                }
                if ("responseMetaData".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseProperties.responseMetadata = ResponseMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticDetectorResponseProperties;
        });
    }
}

