/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.KubeEnvironmentProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppLogsConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ArcConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContainerAppsConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.KubeEnvironmentProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class KubeEnvironmentInner
extends Resource {
    private KubeEnvironmentProperties innerProperties;
    private ExtendedLocation extendedLocation;
    private String kind;
    private String type;
    private String name;
    private String id;

    private KubeEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public KubeEnvironmentInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public KubeEnvironmentInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public KubeEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public KubeEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public KubeEnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    public Boolean internalLoadBalancerEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancerEnabled();
    }

    public KubeEnvironmentInner withInternalLoadBalancerEnabled(Boolean internalLoadBalancerEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withInternalLoadBalancerEnabled(internalLoadBalancerEnabled);
        return this;
    }

    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public KubeEnvironmentInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public String environmentType() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentType();
    }

    public KubeEnvironmentInner withEnvironmentType(String environmentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withEnvironmentType(environmentType);
        return this;
    }

    public ArcConfiguration arcConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().arcConfiguration();
    }

    public KubeEnvironmentInner withArcConfiguration(ArcConfiguration arcConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withArcConfiguration(arcConfiguration);
        return this;
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appLogsConfiguration();
    }

    public KubeEnvironmentInner withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    public ContainerAppsConfiguration containerAppsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().containerAppsConfiguration();
    }

    public KubeEnvironmentInner withContainerAppsConfiguration(ContainerAppsConfiguration containerAppsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withContainerAppsConfiguration(containerAppsConfiguration);
        return this;
    }

    public String aksResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().aksResourceId();
    }

    public KubeEnvironmentInner withAksResourceId(String aksResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withAksResourceId(aksResourceId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static KubeEnvironmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubeEnvironmentInner deserializedKubeEnvironmentInner = new KubeEnvironmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKubeEnvironmentInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.innerProperties = KubeEnvironmentProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubeEnvironmentInner;
        });
    }
}

