/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContentLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Correlation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class WorkflowTriggerHistoryProperties
implements JsonSerializable<WorkflowTriggerHistoryProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private OffsetDateTime scheduledTime;
    private WorkflowStatus status;
    private String code;
    private Object error;
    private String trackingId;
    private Correlation correlation;
    private ContentLink inputsLink;
    private ContentLink outputsLink;
    private Boolean fired;
    private ResourceReference run;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OffsetDateTime scheduledTime() {
        return this.scheduledTime;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public String code() {
        return this.code;
    }

    public Object error() {
        return this.error;
    }

    public String trackingId() {
        return this.trackingId;
    }

    public Correlation correlation() {
        return this.correlation;
    }

    public WorkflowTriggerHistoryProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    public Boolean fired() {
        return this.fired;
    }

    public ResourceReference run() {
        return this.run;
    }

    public void validate() {
        if (this.correlation() != null) {
            this.correlation().validate();
        }
        if (this.inputsLink() != null) {
            this.inputsLink().validate();
        }
        if (this.outputsLink() != null) {
            this.outputsLink().validate();
        }
        if (this.run() != null) {
            this.run().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowTriggerHistoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowTriggerHistoryProperties deserializedWorkflowTriggerHistoryProperties = new WorkflowTriggerHistoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("scheduledTime".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.scheduledTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.status = WorkflowStatus.fromString(reader.getString());
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.code = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.error = reader.readUntyped();
                    continue;
                }
                if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.trackingId = reader.getString();
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.correlation = Correlation.fromJson(reader);
                    continue;
                }
                if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.inputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.outputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("fired".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.fired = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("run".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.run = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowTriggerHistoryProperties;
        });
    }
}

