/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.DomainsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.DomainInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.DomainOwnershipIdentifierInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.TldLegalAgreementInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.DomainContactImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Contact;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DnsType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DomainStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Hostname;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.TopLevelDomainAgreementOption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZone;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class AppServiceDomainImpl
extends GroupableResourceImpl<AppServiceDomain, DomainInner, AppServiceDomainImpl, AppServiceManager>
implements AppServiceDomain,
AppServiceDomain.Definition,
AppServiceDomain.Update {
    private Map<String, Hostname> hostNameMap;
    private Creatable<DnsZone> dnsZoneCreatable;

    AppServiceDomainImpl(String name, DomainInner innerObject, AppServiceManager manager) {
        super(name, innerObject, manager);
        ((DomainInner)this.innerModel()).withLocation("global");
        if (((DomainInner)this.innerModel()).managedHostNames() != null) {
            this.hostNameMap = ((DomainInner)this.innerModel()).managedHostNames().stream().collect(Collectors.toMap(Hostname::name, Function.identity()));
        }
    }

    @Override
    public Mono<AppServiceDomain> createAsync() {
        if (this.isInCreateMode() && ((DomainInner)this.innerModel()).dnsZoneId() == null && this.dnsZoneCreatable == null) {
            this.withNewDnsZone(this.name());
        }
        return super.createAsync();
    }

    @Override
    public Mono<AppServiceDomain> createResourceAsync() {
        if (this.dnsZoneCreatable != null) {
            DnsZone dnsZone = (DnsZone)this.taskResult(this.dnsZoneCreatable.key());
            ((DomainInner)this.innerModel()).withDnsZoneId(dnsZone.id());
        }
        String[] domainParts = this.name().split("\\.");
        String topLevel = domainParts[domainParts.length - 1];
        DomainsClient client = ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getDomains();
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getTopLevelDomains().listAgreementsAsync(topLevel, new TopLevelDomainAgreementOption()).map(TldLegalAgreementInner::agreementKey).collectList().flatMap(keys2 -> {
            try {
                ((DomainInner)this.innerModel()).withConsent(new DomainPurchaseConsent().withAgreedAt(OffsetDateTime.now()).withAgreedBy(Inet4Address.getLocalHost().getHostAddress()).withAgreementKeys((List<String>)keys2));
            }
            catch (UnknownHostException e) {
                return Mono.error(e);
            }
            return client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (DomainInner)this.innerModel());
        }).map(this.innerToFluentMap(this)).doOnSuccess(ignored -> {
            this.dnsZoneCreatable = null;
        });
    }

    @Override
    protected Mono<DomainInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getDomains().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Contact adminContact() {
        return ((DomainInner)this.innerModel()).contactAdmin();
    }

    @Override
    public Contact billingContact() {
        return ((DomainInner)this.innerModel()).contactBilling();
    }

    @Override
    public Contact registrantContact() {
        return ((DomainInner)this.innerModel()).contactRegistrant();
    }

    @Override
    public Contact techContact() {
        return ((DomainInner)this.innerModel()).contactTech();
    }

    @Override
    public DomainStatus registrationStatus() {
        return ((DomainInner)this.innerModel()).registrationStatus();
    }

    @Override
    public List<String> nameServers() {
        return Collections.unmodifiableList(((DomainInner)this.innerModel()).nameServers());
    }

    @Override
    public boolean privacy() {
        return ResourceManagerUtils.toPrimitiveBoolean(((DomainInner)this.innerModel()).privacy());
    }

    @Override
    public OffsetDateTime createdTime() {
        return ((DomainInner)this.innerModel()).createdTime();
    }

    @Override
    public OffsetDateTime expirationTime() {
        return ((DomainInner)this.innerModel()).expirationTime();
    }

    @Override
    public OffsetDateTime lastRenewedTime() {
        return ((DomainInner)this.innerModel()).lastRenewedTime();
    }

    @Override
    public boolean autoRenew() {
        return ResourceManagerUtils.toPrimitiveBoolean(((DomainInner)this.innerModel()).autoRenew());
    }

    @Override
    public boolean readyForDnsRecordManagement() {
        return ResourceManagerUtils.toPrimitiveBoolean(((DomainInner)this.innerModel()).readyForDnsRecordManagement());
    }

    @Override
    public Map<String, Hostname> managedHostNames() {
        if (this.hostNameMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.hostNameMap);
    }

    @Override
    public DomainPurchaseConsent consent() {
        return ((DomainInner)this.innerModel()).consent();
    }

    @Override
    public DnsType dnsType() {
        return ((DomainInner)this.innerModel()).dnsType();
    }

    @Override
    public String dnsZoneId() {
        return ((DomainInner)this.innerModel()).dnsZoneId();
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).block();
    }

    @Override
    public Mono<Void> verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        DomainOwnershipIdentifierInner identifierInner = new DomainOwnershipIdentifierInner().withOwnershipId(domainVerificationToken);
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getDomains().createOrUpdateOwnershipIdentifierAsync(this.resourceGroupName(), this.name(), certificateOrderName, identifierInner).then(Mono.empty());
    }

    @Override
    public AppServiceDomainImpl withAdminContact(Contact contact) {
        ((DomainInner)this.innerModel()).withContactAdmin(contact);
        return this;
    }

    @Override
    public AppServiceDomainImpl withBillingContact(Contact contact) {
        ((DomainInner)this.innerModel()).withContactBilling(contact);
        return this;
    }

    @Override
    public AppServiceDomainImpl withRegistrantContact(Contact contact) {
        ((DomainInner)this.innerModel()).withContactAdmin(contact);
        ((DomainInner)this.innerModel()).withContactBilling(contact);
        ((DomainInner)this.innerModel()).withContactRegistrant(contact);
        ((DomainInner)this.innerModel()).withContactTech(contact);
        return this;
    }

    public DomainContactImpl defineRegistrantContact() {
        return new DomainContactImpl(new Contact(), this);
    }

    @Override
    public AppServiceDomainImpl withTechContact(Contact contact) {
        ((DomainInner)this.innerModel()).withContactTech(contact);
        return this;
    }

    @Override
    public AppServiceDomainImpl withDomainPrivacyEnabled(boolean domainPrivacy) {
        ((DomainInner)this.innerModel()).withPrivacy(domainPrivacy);
        return this;
    }

    @Override
    public AppServiceDomainImpl withAutoRenewEnabled(boolean autoRenew) {
        ((DomainInner)this.innerModel()).withAutoRenew(autoRenew);
        return this;
    }

    @Override
    public AppServiceDomainImpl withNewDnsZone(String dnsZoneName) {
        DnsZone.DefinitionStages.WithCreate dnsZone = this.creatableGroup != null && this.isInCreateMode() ? ((DnsZone.DefinitionStages.WithCreate)((DnsZone.DefinitionStages.Blank)((AppServiceManager)this.manager()).dnsZoneManager().zones().define(dnsZoneName)).withNewResourceGroup(this.creatableGroup)).withETagCheck() : ((DnsZone.DefinitionStages.WithCreate)((DnsZone.DefinitionStages.Blank)((AppServiceManager)this.manager()).dnsZoneManager().zones().define(dnsZoneName)).withExistingResourceGroup(this.resourceGroupName())).withETagCheck();
        return this.withNewDnsZone((Creatable)dnsZone);
    }

    @Override
    public AppServiceDomainImpl withNewDnsZone(Creatable<DnsZone> dnsZone) {
        ((DomainInner)this.innerModel()).withDnsType(DnsType.AZURE_DNS);
        this.dnsZoneCreatable = dnsZone;
        this.addDependency(this.dnsZoneCreatable);
        return this;
    }

    @Override
    public AppServiceDomainImpl withExistingDnsZone(String dnsZoneId) {
        ((DomainInner)this.innerModel()).withDnsType(DnsType.AZURE_DNS);
        ((DomainInner)this.innerModel()).withDnsZoneId(dnsZoneId);
        return this;
    }

    @Override
    public AppServiceDomainImpl withExistingDnsZone(DnsZone dnsZone) {
        return this.withExistingDnsZone(dnsZone.id());
    }
}

