/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AzureResourceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CustomHostnameDnsRecordType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostnameBinding;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostnameType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebApp;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HostnameBindingImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<HostnameBindingInner>
implements Creatable<HostnameBinding>,
HostnameBinding,
HostnameBinding.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
HostnameBinding.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final FluentImplT parent;
    private String domainName;
    private String name;

    HostnameBindingImpl(HostnameBindingInner innerObject, FluentImplT parent) {
        super(innerObject);
        this.parent = parent;
        this.name = innerObject.name();
        if (this.name != null && this.name.contains("/")) {
            this.name = this.name.replace(((ResourceImpl)parent).name() + "/", "");
        }
    }

    @Override
    public String id() {
        return ((HostnameBindingInner)this.innerModel()).id();
    }

    @Override
    public String type() {
        return ((HostnameBindingInner)this.innerModel()).type();
    }

    @Override
    public String regionName() {
        return this.parent().regionName();
    }

    @Override
    public Region region() {
        return this.parent().region();
    }

    @Override
    public Map<String, String> tags() {
        return this.parent().tags();
    }

    @Override
    public String webAppName() {
        return ((HostnameBindingInner)this.innerModel()).siteName();
    }

    @Override
    public String domainId() {
        return ((HostnameBindingInner)this.innerModel()).domainId();
    }

    @Override
    public String azureResourceName() {
        return ((HostnameBindingInner)this.innerModel()).azureResourceName();
    }

    @Override
    public AzureResourceType azureResourceType() {
        return ((HostnameBindingInner)this.innerModel()).azureResourceType();
    }

    @Override
    public CustomHostnameDnsRecordType dnsRecordType() {
        return ((HostnameBindingInner)this.innerModel()).customHostnameDnsRecordType();
    }

    @Override
    public HostnameType hostnameType() {
        return ((HostnameBindingInner)this.innerModel()).hostnameType();
    }

    @Override
    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent).withHostNameBinding(this);
        return this.parent;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withDnsRecordType(CustomHostnameDnsRecordType hostnameDnsRecordType) {
        Pattern pattern = Pattern.compile("([.\\w-]+|\\*)\\.([\\w-]+\\.\\w+)");
        Matcher matcher = pattern.matcher(this.name);
        if (hostnameDnsRecordType == CustomHostnameDnsRecordType.CNAME && !matcher.matches()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("root hostname cannot be assigned with a CName record"));
        }
        ((HostnameBindingInner)this.innerModel()).withCustomHostnameDnsRecordType(hostnameDnsRecordType);
        return this;
    }

    @Override
    public HostnameBindingImpl<FluentT, FluentImplT> refresh() {
        return this;
    }

    @Override
    public Mono<HostnameBinding> refreshAsync() {
        HostnameBindingImpl self = this;
        Mono<HostnameBindingInner> observable2 = null;
        observable2 = this.parent instanceof DeploymentSlot ? ((WebSiteManagementClient)((AppServiceManager)this.parent().manager()).serviceClient()).getWebApps().getHostnameBindingSlotAsync(this.parent().resourceGroupName(), ((WebApp)((DeploymentSlot)this.parent).parent()).name(), this.parent().name(), this.name()) : ((WebSiteManagementClient)((AppServiceManager)this.parent().manager()).serviceClient()).getWebApps().getHostnameBindingAsync(this.parent().resourceGroupName(), this.parent().name(), this.name());
        return observable2.map(hostnameBindingInner -> {
            self.setInner(hostnameBindingInner);
            return self;
        });
    }

    @Override
    public HostnameBinding create() {
        return this.createAsync().block();
    }

    @Override
    public Mono<HostnameBinding> createAsync() {
        return this.createAsync(Context.NONE);
    }

    @Override
    public HostnameBinding create(Context context) {
        return this.createAsync(context).block();
    }

    @Override
    public Mono<HostnameBinding> createAsync(Context context) {
        HostnameBindingImpl self = this;
        Function<HostnameBindingInner, HostnameBinding> mapper = hostnameBindingInner -> {
            this.setInner(hostnameBindingInner);
            return self;
        };
        Mono<HostnameBinding> hostnameBindingObservable = this.parent instanceof DeploymentSlot ? ((WebSiteManagementClient)((AppServiceManager)this.parent().manager()).serviceClient()).getWebApps().createOrUpdateHostnameBindingSlotAsync(this.parent().resourceGroupName(), ((WebApp)((DeploymentSlot)this.parent).parent()).name(), this.name, this.parent().name(), (HostnameBindingInner)this.innerModel()).contextWrite(c -> c.putAll(FluxUtil.toReactorContext(context).readOnly())).map(mapper) : ((WebSiteManagementClient)((AppServiceManager)this.parent().manager()).serviceClient()).getWebApps().createOrUpdateHostnameBindingAsync(this.parent().resourceGroupName(), this.parent().name(), this.name, (HostnameBindingInner)this.innerModel()).contextWrite(c -> c.putAll(FluxUtil.toReactorContext(context).readOnly())).map(mapper);
        return hostnameBindingObservable;
    }

    private String normalizeHostNameBindingName(String hostname, String domainName) {
        if (!hostname.endsWith(domainName)) {
            hostname = hostname + "." + domainName;
        }
        if (hostname.startsWith("@")) {
            hostname = hostname.replace("@.", "");
        }
        return hostname;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withAzureManagedDomain(AppServiceDomain domain) {
        ((HostnameBindingInner)this.innerModel()).withDomainId(domain.id());
        ((HostnameBindingInner)this.innerModel()).withHostnameType(HostnameType.MANAGED);
        this.domainName = domain.name();
        return this;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withThirdPartyDomain(String domain) {
        ((HostnameBindingInner)this.innerModel()).withHostnameType(HostnameType.VERIFIED);
        this.domainName = domain;
        return this;
    }

    @Override
    public String toString() {
        String suffix = this.azureResourceType() == AzureResourceType.TRAFFIC_MANAGER ? ".trafficmanager.net" : ".azurewebsites.net";
        return this.name + ": " + (Object)((Object)this.dnsRecordType()) + " " + this.azureResourceName() + suffix;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WebAppBase parent() {
        return this.parent;
    }

    public HostnameBindingImpl<FluentT, FluentImplT> withSubDomain(String subDomain) {
        this.name = this.normalizeHostNameBindingName(subDomain, this.domainName);
        return this;
    }
}

