/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContentHash;
import java.io.IOException;

public final class ContentLink
implements JsonSerializable<ContentLink> {
    private String uri;
    private String contentVersion;
    private Long contentSize;
    private ContentHash contentHash;
    private Object metadata;

    public String uri() {
        return this.uri;
    }

    public ContentLink withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String contentVersion() {
        return this.contentVersion;
    }

    public Long contentSize() {
        return this.contentSize;
    }

    public ContentHash contentHash() {
        return this.contentHash;
    }

    public Object metadata() {
        return this.metadata;
    }

    public void validate() {
        if (this.contentHash() != null) {
            this.contentHash().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    public static ContentLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContentLink deserializedContentLink = new ContentLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    deserializedContentLink.uri = reader.getString();
                    continue;
                }
                if ("contentVersion".equals(fieldName)) {
                    deserializedContentLink.contentVersion = reader.getString();
                    continue;
                }
                if ("contentSize".equals(fieldName)) {
                    deserializedContentLink.contentSize = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("contentHash".equals(fieldName)) {
                    deserializedContentLink.contentHash = ContentHash.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedContentLink.metadata = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContentLink;
        });
    }
}

