/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DaprMetadata;
import java.io.IOException;
import java.util.List;

public final class DaprComponent
implements JsonSerializable<DaprComponent> {
    private String name;
    private String type;
    private String version;
    private List<DaprMetadata> metadata;

    public String name() {
        return this.name;
    }

    public DaprComponent withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public DaprComponent withType(String type) {
        this.type = type;
        return this;
    }

    public String version() {
        return this.version;
    }

    public DaprComponent withVersion(String version) {
        this.version = version;
        return this;
    }

    public List<DaprMetadata> metadata() {
        return this.metadata;
    }

    public DaprComponent withMetadata(List<DaprMetadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static DaprComponent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponent deserializedDaprComponent = new DaprComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDaprComponent.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDaprComponent.type = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedDaprComponent.version = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List<DaprMetadata> metadata = reader.readArray(reader1 -> DaprMetadata.fromJson(reader1));
                    deserializedDaprComponent.metadata = metadata;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprComponent;
        });
    }
}

