/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.NameValuePair;
import java.io.IOException;
import java.util.List;

public final class DataSource
implements JsonSerializable<DataSource> {
    private List<String> instructions;
    private List<NameValuePair> dataSourceUri;

    public List<String> instructions() {
        return this.instructions;
    }

    public DataSource withInstructions(List<String> instructions) {
        this.instructions = instructions;
        return this;
    }

    public List<NameValuePair> dataSourceUri() {
        return this.dataSourceUri;
    }

    public DataSource withDataSourceUri(List<NameValuePair> dataSourceUri) {
        this.dataSourceUri = dataSourceUri;
        return this;
    }

    public void validate() {
        if (this.dataSourceUri() != null) {
            this.dataSourceUri().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("instructions", this.instructions, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("dataSourceUri", this.dataSourceUri, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static DataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataSource deserializedDataSource = new DataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instructions".equals(fieldName)) {
                    List<String> instructions = reader.readArray(reader1 -> reader1.getString());
                    deserializedDataSource.instructions = instructions;
                    continue;
                }
                if ("dataSourceUri".equals(fieldName)) {
                    List<NameValuePair> dataSourceUri = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    deserializedDataSource.dataSourceUri = dataSourceUri;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataSource;
        });
    }
}

