/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DiagnosticMetricSample
implements JsonSerializable<DiagnosticMetricSample> {
    private OffsetDateTime timestamp;
    private String roleInstance;
    private Double total;
    private Double maximum;
    private Double minimum;
    private Boolean isAggregated;

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public DiagnosticMetricSample withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String roleInstance() {
        return this.roleInstance;
    }

    public DiagnosticMetricSample withRoleInstance(String roleInstance) {
        this.roleInstance = roleInstance;
        return this;
    }

    public Double total() {
        return this.total;
    }

    public DiagnosticMetricSample withTotal(Double total) {
        this.total = total;
        return this;
    }

    public Double maximum() {
        return this.maximum;
    }

    public DiagnosticMetricSample withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double minimum() {
        return this.minimum;
    }

    public DiagnosticMetricSample withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean isAggregated() {
        return this.isAggregated;
    }

    public DiagnosticMetricSample withIsAggregated(Boolean isAggregated) {
        this.isAggregated = isAggregated;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("roleInstance", this.roleInstance);
        jsonWriter.writeNumberField("total", this.total);
        jsonWriter.writeNumberField("maximum", this.maximum);
        jsonWriter.writeNumberField("minimum", this.minimum);
        jsonWriter.writeBooleanField("isAggregated", this.isAggregated);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticMetricSample fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticMetricSample deserializedDiagnosticMetricSample = new DiagnosticMetricSample();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedDiagnosticMetricSample.timestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("roleInstance".equals(fieldName)) {
                    deserializedDiagnosticMetricSample.roleInstance = reader.getString();
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedDiagnosticMetricSample.total = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedDiagnosticMetricSample.maximum = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    deserializedDiagnosticMetricSample.minimum = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("isAggregated".equals(fieldName)) {
                    deserializedDiagnosticMetricSample.isAggregated = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticMetricSample;
        });
    }
}

