/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.IpAddressRange;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OpenAuthenticationAccessPolicies;
import java.io.IOException;
import java.util.List;

public final class FlowAccessControlConfigurationPolicy
implements JsonSerializable<FlowAccessControlConfigurationPolicy> {
    private List<IpAddressRange> allowedCallerIpAddresses;
    private OpenAuthenticationAccessPolicies openAuthenticationPolicies;

    public List<IpAddressRange> allowedCallerIpAddresses() {
        return this.allowedCallerIpAddresses;
    }

    public FlowAccessControlConfigurationPolicy withAllowedCallerIpAddresses(List<IpAddressRange> allowedCallerIpAddresses) {
        this.allowedCallerIpAddresses = allowedCallerIpAddresses;
        return this;
    }

    public OpenAuthenticationAccessPolicies openAuthenticationPolicies() {
        return this.openAuthenticationPolicies;
    }

    public FlowAccessControlConfigurationPolicy withOpenAuthenticationPolicies(OpenAuthenticationAccessPolicies openAuthenticationPolicies) {
        this.openAuthenticationPolicies = openAuthenticationPolicies;
        return this;
    }

    public void validate() {
        if (this.allowedCallerIpAddresses() != null) {
            this.allowedCallerIpAddresses().forEach(e -> e.validate());
        }
        if (this.openAuthenticationPolicies() != null) {
            this.openAuthenticationPolicies().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedCallerIpAddresses", this.allowedCallerIpAddresses, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("openAuthenticationPolicies", this.openAuthenticationPolicies);
        return jsonWriter.writeEndObject();
    }

    public static FlowAccessControlConfigurationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowAccessControlConfigurationPolicy deserializedFlowAccessControlConfigurationPolicy = new FlowAccessControlConfigurationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedCallerIpAddresses".equals(fieldName)) {
                    List<IpAddressRange> allowedCallerIpAddresses = reader.readArray(reader1 -> IpAddressRange.fromJson(reader1));
                    deserializedFlowAccessControlConfigurationPolicy.allowedCallerIpAddresses = allowedCallerIpAddresses;
                    continue;
                }
                if ("openAuthenticationPolicies".equals(fieldName)) {
                    deserializedFlowAccessControlConfigurationPolicy.openAuthenticationPolicies = OpenAuthenticationAccessPolicies.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowAccessControlConfigurationPolicy;
        });
    }
}

