/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Container;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Dapr;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Scale;
import java.io.IOException;
import java.util.List;

public final class Template
implements JsonSerializable<Template> {
    private String revisionSuffix;
    private List<Container> containers;
    private Scale scale;
    private Dapr dapr;

    public String revisionSuffix() {
        return this.revisionSuffix;
    }

    public Template withRevisionSuffix(String revisionSuffix) {
        this.revisionSuffix = revisionSuffix;
        return this;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public Template withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public Scale scale() {
        return this.scale;
    }

    public Template withScale(Scale scale) {
        this.scale = scale;
        return this;
    }

    public Dapr dapr() {
        return this.dapr;
    }

    public Template withDapr(Dapr dapr) {
        this.dapr = dapr;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.scale() != null) {
            this.scale().validate();
        }
        if (this.dapr() != null) {
            this.dapr().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revisionSuffix", this.revisionSuffix);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("scale", this.scale);
        jsonWriter.writeJsonField("dapr", this.dapr);
        return jsonWriter.writeEndObject();
    }

    public static Template fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Template deserializedTemplate = new Template();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("revisionSuffix".equals(fieldName)) {
                    deserializedTemplate.revisionSuffix = reader.getString();
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List<Container> containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    deserializedTemplate.containers = containers;
                    continue;
                }
                if ("scale".equals(fieldName)) {
                    deserializedTemplate.scale = Scale.fromJson(reader);
                    continue;
                }
                if ("dapr".equals(fieldName)) {
                    deserializedTemplate.dapr = Dapr.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTemplate;
        });
    }
}

