/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ErrorEntity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WorkflowHealthState;
import java.io.IOException;

public final class WorkflowHealth
implements JsonSerializable<WorkflowHealth> {
    private WorkflowHealthState state;
    private ErrorEntity error;
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowHealth.class);

    public WorkflowHealthState state() {
        return this.state;
    }

    public WorkflowHealth withState(WorkflowHealthState state) {
        this.state = state;
        return this;
    }

    public ErrorEntity error() {
        return this.error;
    }

    public WorkflowHealth withError(ErrorEntity error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property state in model WorkflowHealth"));
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowHealth fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowHealth deserializedWorkflowHealth = new WorkflowHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedWorkflowHealth.state = WorkflowHealthState.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWorkflowHealth.error = ErrorEntity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowHealth;
        });
    }
}

