/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPolicyBase;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MicrosoftGraphStsPolicy
extends MicrosoftGraphPolicyBase {
    private List<String> definition;
    private Boolean isOrganizationDefault;
    private List<MicrosoftGraphDirectoryObjectInner> appliesTo;
    private Map<String, Object> additionalProperties;

    public List<String> definition() {
        return this.definition;
    }

    public MicrosoftGraphStsPolicy withDefinition(List<String> definition) {
        this.definition = definition;
        return this;
    }

    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    public MicrosoftGraphStsPolicy withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    public List<MicrosoftGraphDirectoryObjectInner> appliesTo() {
        return this.appliesTo;
    }

    public MicrosoftGraphStsPolicy withAppliesTo(List<MicrosoftGraphDirectoryObjectInner> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphStsPolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphStsPolicy withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MicrosoftGraphStsPolicy withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public MicrosoftGraphStsPolicy withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphStsPolicy withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.appliesTo() != null) {
            this.appliesTo().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeArrayField("definition", this.definition, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("isOrganizationDefault", this.isOrganizationDefault);
        jsonWriter.writeArrayField("appliesTo", this.appliesTo, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphStsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphStsPolicy deserializedMicrosoftGraphStsPolicy = new MicrosoftGraphStsPolicy();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withDeletedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withDescription(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withDisplayName(reader.getString());
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    List<String> definition = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphStsPolicy.definition = definition;
                    continue;
                }
                if ("isOrganizationDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.isOrganizationDefault = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appliesTo".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> appliesTo = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphStsPolicy.appliesTo = appliesTo;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphStsPolicy.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphStsPolicy;
        });
    }
}

