/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleEntity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleEntityTheme;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTimeOffItem
extends MicrosoftGraphScheduleEntity {
    private String timeOffReasonId;
    private Map<String, Object> additionalProperties;

    public String timeOffReasonId() {
        return this.timeOffReasonId;
    }

    public MicrosoftGraphTimeOffItem withTimeOffReasonId(String timeOffReasonId) {
        this.timeOffReasonId = timeOffReasonId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTimeOffItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endDateTime", this.endDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime()));
        jsonWriter.writeStringField("startDateTime", this.startDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime()));
        jsonWriter.writeStringField("theme", this.theme() == null ? null : this.theme().toString());
        jsonWriter.writeStringField("timeOffReasonId", this.timeOffReasonId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTimeOffItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTimeOffItem deserializedMicrosoftGraphTimeOffItem = new MicrosoftGraphTimeOffItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.withEndDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.withStartDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.withTheme(MicrosoftGraphScheduleEntityTheme.fromString(reader.getString()));
                    continue;
                }
                if ("timeOffReasonId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffItem.timeOffReasonId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTimeOffItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTimeOffItem;
        });
    }
}

