/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.DomainsDomainsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.CollectionOfDomain;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DomainsDomainsClientImpl
implements DomainsDomainsClient {
    private final DomainsDomainsService service;
    private final MicrosoftGraphClientImpl client;

    DomainsDomainsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = RestProxy.create(DomainsDomainsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainInner>> listDomainSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listDomain(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, MicrosoftGraphDomainInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomain)res.getValue()).value(), ((CollectionOfDomain)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainInner>> listDomainSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listDomain(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase<Object, MicrosoftGraphDomainInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomain)res.getValue()).value(), ((CollectionOfDomain)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDomainInner> listDomainAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand) {
        return new PagedFlux<MicrosoftGraphDomainInner>(() -> this.listDomainSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDomainInner> listDomainAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux<MicrosoftGraphDomainInner>(() -> this.listDomainSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDomainInner> listDomainAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand, Context context) {
        return new PagedFlux<MicrosoftGraphDomainInner>(() -> this.listDomainSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDomainInner> listDomain() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<Get5ItemsItem> orderby = null;
        List<Get6ItemsItem> select = null;
        List<Get7ItemsItem> expand = null;
        return new PagedIterable<MicrosoftGraphDomainInner>(this.listDomainAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDomainInner> listDomain(Integer top, Integer skip, String search, String filter, Boolean count, List<Get5ItemsItem> orderby, List<Get6ItemsItem> select, List<Get7ItemsItem> expand, Context context) {
        return new PagedIterable<MicrosoftGraphDomainInner>(this.listDomainAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainInner>> createDomainWithResponseAsync(MicrosoftGraphDomainInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDomain(this.client.getEndpoint(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainInner>> createDomainWithResponseAsync(MicrosoftGraphDomainInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDomain(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainInner> createDomainAsync(MicrosoftGraphDomainInner body) {
        return this.createDomainWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((MicrosoftGraphDomainInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainInner> createDomainWithResponse(MicrosoftGraphDomainInner body, Context context) {
        return this.createDomainWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDomainInner createDomain(MicrosoftGraphDomainInner body) {
        return this.createDomainWithResponse(body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDomainInner>> getDomainWithResponseAsync(String domainId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getDomain(this.client.getEndpoint(), domainId, selectConverted, expandConverted, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDomainInner>> getDomainWithResponseAsync(String domainId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.getDomain(this.client.getEndpoint(), domainId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDomainInner> getDomainAsync(String domainId) {
        List<Get1ItemsItem> select = null;
        List<Get2ItemsItem> expand = null;
        return this.getDomainWithResponseAsync(domainId, select, expand).flatMap(res -> Mono.justOrEmpty((MicrosoftGraphDomainInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDomainInner> getDomainWithResponse(String domainId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand, Context context) {
        return this.getDomainWithResponseAsync(domainId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDomainInner getDomain(String domainId) {
        List<Get1ItemsItem> select = null;
        List<Get2ItemsItem> expand = null;
        return this.getDomainWithResponse(domainId, select, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateDomainWithResponseAsync(String domainId, MicrosoftGraphDomainInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDomain(this.client.getEndpoint(), domainId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateDomainWithResponseAsync(String domainId, MicrosoftGraphDomainInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDomain(this.client.getEndpoint(), domainId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateDomainAsync(String domainId, MicrosoftGraphDomainInner body) {
        return this.updateDomainWithResponseAsync(domainId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateDomainWithResponse(String domainId, MicrosoftGraphDomainInner body, Context context) {
        return this.updateDomainWithResponseAsync(domainId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateDomain(String domainId, MicrosoftGraphDomainInner body) {
        this.updateDomainWithResponse(domainId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDomainWithResponseAsync(String domainId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDomain(this.client.getEndpoint(), domainId, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDomainWithResponseAsync(String domainId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error(new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDomain(this.client.getEndpoint(), domainId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDomainAsync(String domainId) {
        String ifMatch = null;
        return this.deleteDomainWithResponseAsync(domainId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDomainWithResponse(String domainId, String ifMatch, Context context) {
        return this.deleteDomainWithResponseAsync(domainId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDomain(String domainId) {
        String ifMatch = null;
        this.deleteDomainWithResponse(domainId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase<Object, MicrosoftGraphDomainInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomain)res.getValue()).value(), ((CollectionOfDomain)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDomainInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase<Object, MicrosoftGraphDomainInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomain)res.getValue()).value(), ((CollectionOfDomain)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    public static interface DomainsDomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDomain>> listDomain(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/domains")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainInner>> createDomain(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphDomainInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainInner>> getDomain(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/domains/{domain-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateDomain(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDomainInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/domains/{domain-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteDomain(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDomain>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

