/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.RoleAssignmentScheduleInstancesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentScheduleInstanceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleInstanceListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class RoleAssignmentScheduleInstancesClientImpl
implements RoleAssignmentScheduleInstancesClient {
    private final RoleAssignmentScheduleInstancesService service;
    private final AuthorizationManagementClientImpl client;

    RoleAssignmentScheduleInstancesClientImpl(AuthorizationManagementClientImpl client) {
        this.service = RestProxy.create(RoleAssignmentScheduleInstancesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleInstanceInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RoleAssignmentScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).value(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleInstanceInner>> listForScopeSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", context).map(res -> new PagedResponseBase<Object, RoleAssignmentScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).value(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentScheduleInstanceInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux<RoleAssignmentScheduleInstanceInner>(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentScheduleInstanceInner> listForScopeAsync(String scope) {
        String filter = null;
        return new PagedFlux<RoleAssignmentScheduleInstanceInner>(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentScheduleInstanceInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux<RoleAssignmentScheduleInstanceInner>(() -> this.listForScopeSinglePageAsync(scope, filter, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentScheduleInstanceInner> listForScope(String scope) {
        String filter = null;
        return new PagedIterable<RoleAssignmentScheduleInstanceInner>(this.listForScopeAsync(scope, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentScheduleInstanceInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable<RoleAssignmentScheduleInstanceInner>(this.listForScopeAsync(scope, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentScheduleInstanceInner>> getWithResponseAsync(String scope, String roleAssignmentScheduleInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleAssignmentScheduleInstanceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, roleAssignmentScheduleInstanceName, "2020-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentScheduleInstanceInner>> getWithResponseAsync(String scope, String roleAssignmentScheduleInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleAssignmentScheduleInstanceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, roleAssignmentScheduleInstanceName, "2020-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentScheduleInstanceInner> getAsync(String scope, String roleAssignmentScheduleInstanceName) {
        return this.getWithResponseAsync(scope, roleAssignmentScheduleInstanceName).flatMap(res -> Mono.justOrEmpty((RoleAssignmentScheduleInstanceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentScheduleInstanceInner> getWithResponse(String scope, String roleAssignmentScheduleInstanceName, Context context) {
        return this.getWithResponseAsync(scope, roleAssignmentScheduleInstanceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentScheduleInstanceInner get(String scope, String roleAssignmentScheduleInstanceName) {
        return this.getWithResponse(scope, roleAssignmentScheduleInstanceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleInstanceInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RoleAssignmentScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).value(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleInstanceInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, RoleAssignmentScheduleInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).value(), ((RoleAssignmentScheduleInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    public static interface RoleAssignmentScheduleInstancesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleInstances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleInstanceListResult>> listForScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleInstances/{roleAssignmentScheduleInstanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleInstanceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentScheduleInstanceName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleInstanceListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

