/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.PrivateEndpointStatus;
import java.io.IOException;

public final class DeepCreatedOriginProperties
implements JsonSerializable<DeepCreatedOriginProperties> {
    private String hostname;
    private Integer httpPort;
    private Integer httpsPort;
    private String originHostHeader;
    private Integer priority;
    private Integer weight;
    private Boolean enabled;
    private String privateLinkAlias;
    private String privateLinkResourceId;
    private String privateLinkLocation;
    private String privateLinkApprovalMessage;
    private PrivateEndpointStatus privateEndpointStatus;
    private static final ClientLogger LOGGER = new ClientLogger(DeepCreatedOriginProperties.class);

    public String hostname() {
        return this.hostname;
    }

    public DeepCreatedOriginProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public DeepCreatedOriginProperties withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public DeepCreatedOriginProperties withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String originHostHeader() {
        return this.originHostHeader;
    }

    public DeepCreatedOriginProperties withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public DeepCreatedOriginProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public DeepCreatedOriginProperties withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public DeepCreatedOriginProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String privateLinkAlias() {
        return this.privateLinkAlias;
    }

    public DeepCreatedOriginProperties withPrivateLinkAlias(String privateLinkAlias) {
        this.privateLinkAlias = privateLinkAlias;
        return this;
    }

    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    public DeepCreatedOriginProperties withPrivateLinkResourceId(String privateLinkResourceId) {
        this.privateLinkResourceId = privateLinkResourceId;
        return this;
    }

    public String privateLinkLocation() {
        return this.privateLinkLocation;
    }

    public DeepCreatedOriginProperties withPrivateLinkLocation(String privateLinkLocation) {
        this.privateLinkLocation = privateLinkLocation;
        return this;
    }

    public String privateLinkApprovalMessage() {
        return this.privateLinkApprovalMessage;
    }

    public DeepCreatedOriginProperties withPrivateLinkApprovalMessage(String privateLinkApprovalMessage) {
        this.privateLinkApprovalMessage = privateLinkApprovalMessage;
        return this;
    }

    public PrivateEndpointStatus privateEndpointStatus() {
        return this.privateEndpointStatus;
    }

    public void validate() {
        if (this.hostname() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property hostname in model DeepCreatedOriginProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeNumberField("httpPort", this.httpPort);
        jsonWriter.writeNumberField("httpsPort", this.httpsPort);
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeNumberField("weight", this.weight);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("privateLinkAlias", this.privateLinkAlias);
        jsonWriter.writeStringField("privateLinkResourceId", this.privateLinkResourceId);
        jsonWriter.writeStringField("privateLinkLocation", this.privateLinkLocation);
        jsonWriter.writeStringField("privateLinkApprovalMessage", this.privateLinkApprovalMessage);
        return jsonWriter.writeEndObject();
    }

    public static DeepCreatedOriginProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeepCreatedOriginProperties deserializedDeepCreatedOriginProperties = new DeepCreatedOriginProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hostName".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.hostname = reader.getString();
                    continue;
                }
                if ("httpPort".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.httpPort = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpsPort".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.httpsPort = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.originHostHeader = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.priority = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.weight = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("privateLinkAlias".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.privateLinkAlias = reader.getString();
                    continue;
                }
                if ("privateLinkResourceId".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.privateLinkResourceId = reader.getString();
                    continue;
                }
                if ("privateLinkLocation".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.privateLinkLocation = reader.getString();
                    continue;
                }
                if ("privateLinkApprovalMessage".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.privateLinkApprovalMessage = reader.getString();
                    continue;
                }
                if ("privateEndpointStatus".equals(fieldName)) {
                    deserializedDeepCreatedOriginProperties.privateEndpointStatus = PrivateEndpointStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeepCreatedOriginProperties;
        });
    }
}

