/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.WafMetricsGranularity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.WafMetricsResponseSeriesItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class WafMetricsResponseInner
implements JsonSerializable<WafMetricsResponseInner> {
    private OffsetDateTime dateTimeBegin;
    private OffsetDateTime dateTimeEnd;
    private WafMetricsGranularity granularity;
    private List<WafMetricsResponseSeriesItem> series;

    public OffsetDateTime dateTimeBegin() {
        return this.dateTimeBegin;
    }

    public WafMetricsResponseInner withDateTimeBegin(OffsetDateTime dateTimeBegin) {
        this.dateTimeBegin = dateTimeBegin;
        return this;
    }

    public OffsetDateTime dateTimeEnd() {
        return this.dateTimeEnd;
    }

    public WafMetricsResponseInner withDateTimeEnd(OffsetDateTime dateTimeEnd) {
        this.dateTimeEnd = dateTimeEnd;
        return this;
    }

    public WafMetricsGranularity granularity() {
        return this.granularity;
    }

    public WafMetricsResponseInner withGranularity(WafMetricsGranularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public List<WafMetricsResponseSeriesItem> series() {
        return this.series;
    }

    public WafMetricsResponseInner withSeries(List<WafMetricsResponseSeriesItem> series) {
        this.series = series;
        return this;
    }

    public void validate() {
        if (this.series() != null) {
            this.series().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dateTimeBegin", this.dateTimeBegin == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeBegin));
        jsonWriter.writeStringField("dateTimeEnd", this.dateTimeEnd == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTimeEnd));
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeArrayField("series", this.series, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static WafMetricsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WafMetricsResponseInner deserializedWafMetricsResponseInner = new WafMetricsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateTimeBegin".equals(fieldName)) {
                    deserializedWafMetricsResponseInner.dateTimeBegin = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("dateTimeEnd".equals(fieldName)) {
                    deserializedWafMetricsResponseInner.dateTimeEnd = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("granularity".equals(fieldName)) {
                    deserializedWafMetricsResponseInner.granularity = WafMetricsGranularity.fromString(reader.getString());
                    continue;
                }
                if ("series".equals(fieldName)) {
                    List<WafMetricsResponseSeriesItem> series = reader.readArray(reader1 -> WafMetricsResponseSeriesItem.fromJson(reader1));
                    deserializedWafMetricsResponseInner.series = series;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWafMetricsResponseInner;
        });
    }
}

