/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecretParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecretType;
import java.io.IOException;
import java.util.List;

public final class AzureFirstPartyManagedCertificateParameters
extends SecretParameters {
    private SecretType type = SecretType.AZURE_FIRST_PARTY_MANAGED_CERTIFICATE;
    private ResourceReference secretSource;
    private String subject;
    private String expirationDate;
    private String certificateAuthority;
    private List<String> subjectAlternativeNames;
    private String thumbprint;

    @Override
    public SecretType type() {
        return this.type;
    }

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public String subject() {
        return this.subject;
    }

    public String expirationDate() {
        return this.expirationDate;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public AzureFirstPartyManagedCertificateParameters withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.secretSource() != null) {
            this.secretSource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("subjectAlternativeNames", this.subjectAlternativeNames, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureFirstPartyManagedCertificateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirstPartyManagedCertificateParameters deserializedAzureFirstPartyManagedCertificateParameters = new AzureFirstPartyManagedCertificateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.type = SecretType.fromString(reader.getString());
                    continue;
                }
                if ("secretSource".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.secretSource = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.subject = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.expirationDate = reader.getString();
                    continue;
                }
                if ("certificateAuthority".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.certificateAuthority = reader.getString();
                    continue;
                }
                if ("subjectAlternativeNames".equals(fieldName)) {
                    List<String> subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirstPartyManagedCertificateParameters.subjectAlternativeNames = subjectAlternativeNames;
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.thumbprint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirstPartyManagedCertificateParameters;
        });
    }
}

