/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ImageStorageProfile;
import java.io.IOException;

public final class ImageProperties
implements JsonSerializable<ImageProperties> {
    private SubResource sourceVirtualMachine;
    private ImageStorageProfile storageProfile;
    private String provisioningState;
    private HyperVGenerationTypes hyperVGeneration;

    public SubResource sourceVirtualMachine() {
        return this.sourceVirtualMachine;
    }

    public ImageProperties withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        this.sourceVirtualMachine = sourceVirtualMachine;
        return this;
    }

    public ImageStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ImageProperties withStorageProfile(ImageStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public ImageProperties withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVirtualMachine", this.sourceVirtualMachine);
        jsonWriter.writeJsonField("storageProfile", this.storageProfile);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        return jsonWriter.writeEndObject();
    }

    public static ImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageProperties deserializedImageProperties = new ImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceVirtualMachine".equals(fieldName)) {
                    deserializedImageProperties.sourceVirtualMachine = SubResource.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedImageProperties.storageProfile = ImageStorageProfile.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedImageProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedImageProperties.hyperVGeneration = HyperVGenerationTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageProperties;
        });
    }
}

