/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.BootDiagnosticsInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HyperVGenerationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.MaintenanceRedeployStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineAgentInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineHealthStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachinePatchStatus;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineInstanceViewInner
implements JsonSerializable<VirtualMachineInstanceViewInner> {
    private Integer platformUpdateDomain;
    private Integer platformFaultDomain;
    private String computerName;
    private String osName;
    private String osVersion;
    private HyperVGenerationType hyperVGeneration;
    private String rdpThumbPrint;
    private VirtualMachineAgentInstanceView vmAgent;
    private MaintenanceRedeployStatus maintenanceRedeployStatus;
    private List<DiskInstanceView> disks;
    private List<VirtualMachineExtensionInstanceView> extensions;
    private VirtualMachineHealthStatus vmHealth;
    private BootDiagnosticsInstanceView bootDiagnostics;
    private String assignedHost;
    private List<InstanceViewStatus> statuses;
    private VirtualMachinePatchStatus patchStatus;
    private Boolean isVMInStandbyPool;

    public Integer platformUpdateDomain() {
        return this.platformUpdateDomain;
    }

    public VirtualMachineInstanceViewInner withPlatformUpdateDomain(Integer platformUpdateDomain) {
        this.platformUpdateDomain = platformUpdateDomain;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public VirtualMachineInstanceViewInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public String computerName() {
        return this.computerName;
    }

    public VirtualMachineInstanceViewInner withComputerName(String computerName) {
        this.computerName = computerName;
        return this;
    }

    public String osName() {
        return this.osName;
    }

    public VirtualMachineInstanceViewInner withOsName(String osName) {
        this.osName = osName;
        return this;
    }

    public String osVersion() {
        return this.osVersion;
    }

    public VirtualMachineInstanceViewInner withOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public HyperVGenerationType hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualMachineInstanceViewInner withHyperVGeneration(HyperVGenerationType hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public String rdpThumbPrint() {
        return this.rdpThumbPrint;
    }

    public VirtualMachineInstanceViewInner withRdpThumbPrint(String rdpThumbPrint) {
        this.rdpThumbPrint = rdpThumbPrint;
        return this;
    }

    public VirtualMachineAgentInstanceView vmAgent() {
        return this.vmAgent;
    }

    public VirtualMachineInstanceViewInner withVmAgent(VirtualMachineAgentInstanceView vmAgent) {
        this.vmAgent = vmAgent;
        return this;
    }

    public MaintenanceRedeployStatus maintenanceRedeployStatus() {
        return this.maintenanceRedeployStatus;
    }

    public VirtualMachineInstanceViewInner withMaintenanceRedeployStatus(MaintenanceRedeployStatus maintenanceRedeployStatus) {
        this.maintenanceRedeployStatus = maintenanceRedeployStatus;
        return this;
    }

    public List<DiskInstanceView> disks() {
        return this.disks;
    }

    public VirtualMachineInstanceViewInner withDisks(List<DiskInstanceView> disks) {
        this.disks = disks;
        return this;
    }

    public List<VirtualMachineExtensionInstanceView> extensions() {
        return this.extensions;
    }

    public VirtualMachineInstanceViewInner withExtensions(List<VirtualMachineExtensionInstanceView> extensions) {
        this.extensions = extensions;
        return this;
    }

    public VirtualMachineHealthStatus vmHealth() {
        return this.vmHealth;
    }

    public BootDiagnosticsInstanceView bootDiagnostics() {
        return this.bootDiagnostics;
    }

    public VirtualMachineInstanceViewInner withBootDiagnostics(BootDiagnosticsInstanceView bootDiagnostics) {
        this.bootDiagnostics = bootDiagnostics;
        return this;
    }

    public String assignedHost() {
        return this.assignedHost;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public VirtualMachineInstanceViewInner withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public VirtualMachinePatchStatus patchStatus() {
        return this.patchStatus;
    }

    public VirtualMachineInstanceViewInner withPatchStatus(VirtualMachinePatchStatus patchStatus) {
        this.patchStatus = patchStatus;
        return this;
    }

    public Boolean isVMInStandbyPool() {
        return this.isVMInStandbyPool;
    }

    public void validate() {
        if (this.vmAgent() != null) {
            this.vmAgent().validate();
        }
        if (this.maintenanceRedeployStatus() != null) {
            this.maintenanceRedeployStatus().validate();
        }
        if (this.disks() != null) {
            this.disks().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.vmHealth() != null) {
            this.vmHealth().validate();
        }
        if (this.bootDiagnostics() != null) {
            this.bootDiagnostics().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
        if (this.patchStatus() != null) {
            this.patchStatus().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("platformUpdateDomain", this.platformUpdateDomain);
        jsonWriter.writeNumberField("platformFaultDomain", this.platformFaultDomain);
        jsonWriter.writeStringField("computerName", this.computerName);
        jsonWriter.writeStringField("osName", this.osName);
        jsonWriter.writeStringField("osVersion", this.osVersion);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeStringField("rdpThumbPrint", this.rdpThumbPrint);
        jsonWriter.writeJsonField("vmAgent", this.vmAgent);
        jsonWriter.writeJsonField("maintenanceRedeployStatus", this.maintenanceRedeployStatus);
        jsonWriter.writeArrayField("disks", this.disks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("bootDiagnostics", this.bootDiagnostics);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("patchStatus", this.patchStatus);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceViewInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineInstanceViewInner deserializedVirtualMachineInstanceViewInner = new VirtualMachineInstanceViewInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("platformUpdateDomain".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.platformUpdateDomain = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("platformFaultDomain".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.platformFaultDomain = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("computerName".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.computerName = reader.getString();
                    continue;
                }
                if ("osName".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.osName = reader.getString();
                    continue;
                }
                if ("osVersion".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.osVersion = reader.getString();
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.hyperVGeneration = HyperVGenerationType.fromString(reader.getString());
                    continue;
                }
                if ("rdpThumbPrint".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.rdpThumbPrint = reader.getString();
                    continue;
                }
                if ("vmAgent".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.vmAgent = VirtualMachineAgentInstanceView.fromJson(reader);
                    continue;
                }
                if ("maintenanceRedeployStatus".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.maintenanceRedeployStatus = MaintenanceRedeployStatus.fromJson(reader);
                    continue;
                }
                if ("disks".equals(fieldName)) {
                    List<DiskInstanceView> disks = reader.readArray(reader1 -> DiskInstanceView.fromJson(reader1));
                    deserializedVirtualMachineInstanceViewInner.disks = disks;
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List<VirtualMachineExtensionInstanceView> extensions = reader.readArray(reader1 -> VirtualMachineExtensionInstanceView.fromJson(reader1));
                    deserializedVirtualMachineInstanceViewInner.extensions = extensions;
                    continue;
                }
                if ("vmHealth".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.vmHealth = VirtualMachineHealthStatus.fromJson(reader);
                    continue;
                }
                if ("bootDiagnostics".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.bootDiagnostics = BootDiagnosticsInstanceView.fromJson(reader);
                    continue;
                }
                if ("assignedHost".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.assignedHost = reader.getString();
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedVirtualMachineInstanceViewInner.statuses = statuses;
                    continue;
                }
                if ("patchStatus".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.patchStatus = VirtualMachinePatchStatus.fromJson(reader);
                    continue;
                }
                if ("isVMInStandbyPool".equals(fieldName)) {
                    deserializedVirtualMachineInstanceViewInner.isVMInStandbyPool = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceViewInner;
        });
    }
}

