/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.DiskEncryptionSetMsiHandler;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSetIdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSetUpdate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SourceVault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class DiskEncryptionSetImpl
extends GroupableResourceImpl<DiskEncryptionSet, DiskEncryptionSetInner, DiskEncryptionSetImpl, ComputeManager>
implements DiskEncryptionSet,
DiskEncryptionSet.Definition,
DiskEncryptionSet.Update {
    private DiskEncryptionSetUpdate patchToUpdate = new DiskEncryptionSetUpdate();
    private boolean updated;
    private final DiskEncryptionSetMsiHandler msiHandler;

    protected DiskEncryptionSetImpl(String name, DiskEncryptionSetInner innerObject, ComputeManager manager) {
        super(name, innerObject, manager);
        this.msiHandler = new DiskEncryptionSetMsiHandler(manager.authorizationManager(), this);
    }

    @Override
    public String keyVaultId() {
        if (((DiskEncryptionSetInner)this.innerModel()).activeKey() == null || ((DiskEncryptionSetInner)this.innerModel()).activeKey().sourceVault() == null) {
            return null;
        }
        return ((DiskEncryptionSetInner)this.innerModel()).activeKey().sourceVault().id();
    }

    @Override
    public String encryptionKeyId() {
        if (((DiskEncryptionSetInner)this.innerModel()).activeKey() == null) {
            return null;
        }
        return ((DiskEncryptionSetInner)this.innerModel()).activeKey().keyUrl();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((DiskEncryptionSetInner)this.innerModel()).identity() == null || ((DiskEncryptionSetInner)this.innerModel()).identity().type() == DiskEncryptionSetIdentityType.NONE) {
            return null;
        }
        return ((DiskEncryptionSetInner)this.innerModel()).identity().principalId();
    }

    @Override
    public Boolean isAutomaticKeyRotationEnabled() {
        return ((DiskEncryptionSetInner)this.innerModel()).rotationToLatestKeyVersionEnabled();
    }

    @Override
    public DiskEncryptionSetType encryptionType() {
        return ((DiskEncryptionSetInner)this.innerModel()).encryptionType();
    }

    @Override
    public DiskEncryptionSetImpl withAutomaticKeyRotation() {
        ((DiskEncryptionSetInner)this.innerModel()).withRotationToLatestKeyVersionEnabled(true);
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withRotationToLatestKeyVersionEnabled(true);
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withoutAutomaticKeyRotation() {
        ((DiskEncryptionSetInner)this.innerModel()).withRotationToLatestKeyVersionEnabled(false);
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withRotationToLatestKeyVersionEnabled(false);
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withSystemAssignedManagedServiceIdentity() {
        ((DiskEncryptionSetInner)this.innerModel()).withIdentity(new EncryptionSetIdentity().withType(DiskEncryptionSetIdentityType.SYSTEM_ASSIGNED));
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withIdentity(((DiskEncryptionSetInner)this.innerModel()).identity());
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withoutSystemAssignedManagedServiceIdentity() {
        ((DiskEncryptionSetInner)this.innerModel()).withIdentity(new EncryptionSetIdentity().withType(DiskEncryptionSetIdentityType.NONE));
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withIdentity(((DiskEncryptionSetInner)this.innerModel()).identity());
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withExistingKeyVault(String keyVaultId) {
        this.ensureActiveKey();
        ((DiskEncryptionSetInner)this.innerModel()).activeKey().withSourceVault(new SourceVault().withId(keyVaultId));
        if (this.isInUpdateMode()) {
            this.ensureActiveKey(this.patchToUpdate);
            this.patchToUpdate.activeKey().withSourceVault(((DiskEncryptionSetInner)this.innerModel()).activeKey().sourceVault());
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withRoleBasedAccessToCurrentKeyVault(BuiltInRole builtInRole) {
        if (this.keyVaultId() != null) {
            this.msiHandler.withAccessTo(this.keyVaultId(), builtInRole);
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withRoleBasedAccessToCurrentKeyVault() {
        return this.withRoleBasedAccessToCurrentKeyVault(BuiltInRole.KEY_VAULT_CRYPTO_SERVICE_ENCRYPTION_USER);
    }

    @Override
    public Mono<DiskEncryptionSet> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDiskEncryptionSets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (DiskEncryptionSetInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    @Override
    public DiskEncryptionSetImpl update() {
        this.patchToUpdate = new DiskEncryptionSetUpdate();
        return this;
    }

    @Override
    public Mono<DiskEncryptionSet> updateResourceAsync() {
        if (!this.updated) {
            return Mono.just(this);
        }
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDiskEncryptionSets().updateAsync(this.resourceGroupName(), this.name(), this.patchToUpdate).map(inner -> {
            this.setInner(inner);
            this.updated = false;
            return this;
        });
    }

    @Override
    protected Mono<DiskEncryptionSetInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDiskEncryptionSets().getByResourceGroupAsync(this.resourceGroupName(), this.name()).map(inner -> {
            this.updated = false;
            return inner;
        });
    }

    @Override
    public DiskEncryptionSetImpl withExistingKey(String keyId) {
        this.ensureActiveKey();
        ((DiskEncryptionSetInner)this.innerModel()).activeKey().withKeyUrl(keyId);
        if (this.isInUpdateMode()) {
            this.ensureActiveKey(this.patchToUpdate);
            this.patchToUpdate.activeKey().withKeyUrl(keyId);
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withEncryptionType(DiskEncryptionSetType type) {
        ((DiskEncryptionSetInner)this.innerModel()).withEncryptionType(type);
        return this;
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            @Override
            public String principalId() {
                return DiskEncryptionSetImpl.this.systemAssignedManagedServiceIdentityPrincipalId();
            }

            @Override
            public String resourceId() {
                return DiskEncryptionSetImpl.this.id();
            }
        };
    }

    private void ensureActiveKey() {
        if (((DiskEncryptionSetInner)this.innerModel()).activeKey() == null) {
            ((DiskEncryptionSetInner)this.innerModel()).withActiveKey(new KeyForDiskEncryptionSet());
        }
    }

    private void ensureActiveKey(DiskEncryptionSetUpdate patchToUpdate) {
        if (patchToUpdate.activeKey() == null) {
            patchToUpdate.withActiveKey(new KeyForDiskEncryptionSet());
        }
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }
}

